/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.server.computation.task.projectanalysis.issue;

import java.util.ArrayList;
import java.util.List;
import org.sonar.core.issue.DefaultIssue;
import org.sonar.core.issue.tracking.Input;
import org.sonar.core.issue.tracking.Tracker;
import org.sonar.core.issue.tracking.Tracking;
import org.sonar.server.computation.task.projectanalysis.component.Component;
import org.sonar.server.computation.task.projectanalysis.issue.DefaultTrackingInput;
import org.sonar.server.computation.task.projectanalysis.issue.TrackerBaseInputFactory;
import org.sonar.server.computation.task.projectanalysis.issue.TrackerMergeBranchInputFactory;
import org.sonar.server.computation.task.projectanalysis.issue.TrackerRawInputFactory;

public class ShortBranchTrackerExecution {
    private final TrackerBaseInputFactory baseInputFactory;
    private final TrackerRawInputFactory rawInputFactory;
    private final TrackerMergeBranchInputFactory mergeInputFactory;
    private final Tracker<DefaultIssue, DefaultIssue> tracker;

    public ShortBranchTrackerExecution(TrackerBaseInputFactory baseInputFactory, TrackerRawInputFactory rawInputFactory, TrackerMergeBranchInputFactory mergeInputFactory, Tracker<DefaultIssue, DefaultIssue> tracker) {
        this.baseInputFactory = baseInputFactory;
        this.rawInputFactory = rawInputFactory;
        this.mergeInputFactory = mergeInputFactory;
        this.tracker = tracker;
    }

    public Tracking<DefaultIssue, DefaultIssue> track(Component component) {
        Input<DefaultIssue> rawInput = this.rawInputFactory.create(component);
        Input<DefaultIssue> baseInput = this.baseInputFactory.create(component);
        Input<DefaultIssue> mergeInput = this.mergeInputFactory.create(component);
        Tracking mergeTracking = this.tracker.track(rawInput, mergeInput);
        List<DefaultIssue> unmatchedRaws = ShortBranchTrackerExecution.toList(mergeTracking.getUnmatchedRaws());
        DefaultTrackingInput unmatchedRawInput = new DefaultTrackingInput(unmatchedRaws, rawInput.getLineHashSequence(), rawInput.getBlockHashSequence());
        return this.tracker.track((Input)unmatchedRawInput, baseInput);
    }

    private static <T> List<T> toList(Iterable<T> iterable) {
        ArrayList list = new ArrayList();
        iterable.forEach(list::add);
        return list;
    }
}

