/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.server.computation.task.projectanalysis.issue;

import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import java.util.Map;
import java.util.Objects;
import javax.annotation.CheckForNull;
import org.sonar.api.rule.RuleKey;
import org.sonar.db.DbClient;
import org.sonar.db.DbSession;
import org.sonar.db.rule.RuleDto;
import org.sonar.server.computation.task.projectanalysis.analysis.AnalysisMetadataHolder;
import org.sonar.server.computation.task.projectanalysis.issue.Rule;
import org.sonar.server.computation.task.projectanalysis.issue.RuleImpl;
import org.sonar.server.computation.task.projectanalysis.issue.RuleRepository;

public class RuleRepositoryImpl
implements RuleRepository {
    @CheckForNull
    private Map<RuleKey, Rule> rulesByKey;
    @CheckForNull
    private Map<Integer, Rule> rulesById;
    private final DbClient dbClient;
    private final AnalysisMetadataHolder analysisMetadataHolder;

    public RuleRepositoryImpl(DbClient dbClient, AnalysisMetadataHolder analysisMetadataHolder) {
        this.dbClient = dbClient;
        this.analysisMetadataHolder = analysisMetadataHolder;
    }

    @Override
    public Rule getByKey(RuleKey key) {
        RuleRepositoryImpl.verifyKeyArgument(key);
        this.ensureInitialized();
        Rule rule = this.rulesByKey.get(key);
        Preconditions.checkArgument((rule != null ? 1 : 0) != 0, (String)"Can not find rule for key %s. This rule does not exist in DB", (Object[])new Object[]{key});
        return rule;
    }

    @Override
    public Optional<Rule> findByKey(RuleKey key) {
        RuleRepositoryImpl.verifyKeyArgument(key);
        this.ensureInitialized();
        return Optional.fromNullable((Object)this.rulesByKey.get(key));
    }

    @Override
    public Rule getById(int id) {
        this.ensureInitialized();
        Rule rule = this.rulesById.get(id);
        Preconditions.checkArgument((rule != null ? 1 : 0) != 0, (String)"Can not find rule for id %s. This rule does not exist in DB", (Object[])new Object[]{id});
        return rule;
    }

    @Override
    public Optional<Rule> findById(int id) {
        this.ensureInitialized();
        return Optional.fromNullable((Object)this.rulesById.get(id));
    }

    private static void verifyKeyArgument(RuleKey key) {
        Objects.requireNonNull(key, "RuleKey can not be null");
    }

    private void ensureInitialized() {
        if (this.rulesByKey == null) {
            try (DbSession dbSession = this.dbClient.openSession(false);){
                this.loadRulesFromDb(dbSession);
            }
        }
    }

    private void loadRulesFromDb(DbSession dbSession) {
        ImmutableMap.Builder rulesByKeyBuilder = ImmutableMap.builder();
        ImmutableMap.Builder rulesByIdBuilder = ImmutableMap.builder();
        String organizationUuid = this.analysisMetadataHolder.getOrganization().getUuid();
        for (RuleDto ruleDto : this.dbClient.ruleDao().selectAll(dbSession, organizationUuid)) {
            RuleImpl rule = new RuleImpl(ruleDto);
            rulesByKeyBuilder.put((Object)ruleDto.getKey(), (Object)rule);
            rulesByIdBuilder.put((Object)ruleDto.getId(), (Object)rule);
        }
        this.rulesByKey = rulesByKeyBuilder.build();
        this.rulesById = rulesByIdBuilder.build();
    }
}

