/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.server.computation.task.projectanalysis.formula;

import com.google.common.base.Optional;
import java.util.Objects;
import org.sonar.api.ce.measure.RangeDistributionBuilder;
import org.sonar.server.computation.task.projectanalysis.component.Component;
import org.sonar.server.computation.task.projectanalysis.component.CrawlerDepthLimit;
import org.sonar.server.computation.task.projectanalysis.formula.Counter;
import org.sonar.server.computation.task.projectanalysis.formula.CounterInitializationContext;
import org.sonar.server.computation.task.projectanalysis.formula.CreateMeasureContext;
import org.sonar.server.computation.task.projectanalysis.formula.Formula;
import org.sonar.server.computation.task.projectanalysis.measure.Measure;

public class DistributionFormula
implements Formula<DistributionCounter> {
    private final String metricKey;

    public DistributionFormula(String metricKey) {
        this.metricKey = Objects.requireNonNull(metricKey, "Metric key cannot be null");
    }

    @Override
    public DistributionCounter createNewCounter() {
        return new DistributionCounter();
    }

    @Override
    public Optional<Measure> createMeasure(DistributionCounter counter, CreateMeasureContext context) {
        Component.Type componentType = context.getComponent().getType();
        Optional<String> value = counter.getValue();
        if (value.isPresent() && CrawlerDepthLimit.LEAVES.isDeeperThan(componentType)) {
            return Optional.of((Object)Measure.newMeasureBuilder().create((String)value.get()));
        }
        return Optional.absent();
    }

    @Override
    public String[] getOutputMetricKeys() {
        return new String[]{this.metricKey};
    }

    class DistributionCounter
    implements Counter<DistributionCounter> {
        private final RangeDistributionBuilder distribution = new RangeDistributionBuilder();
        private boolean initialized = false;

        DistributionCounter() {
        }

        @Override
        public void aggregate(DistributionCounter counter) {
            Optional<String> value = counter.getValue();
            if (value.isPresent()) {
                this.initialized = true;
                this.distribution.add((String)value.get());
            }
        }

        @Override
        public void initialize(CounterInitializationContext context) {
            String data;
            Optional<Measure> measureOptional = context.getMeasure(DistributionFormula.this.metricKey);
            String string = data = measureOptional.isPresent() ? ((Measure)measureOptional.get()).getData() : null;
            if (data != null) {
                this.initialized = true;
                this.distribution.add(data);
            }
        }

        public Optional<String> getValue() {
            if (this.initialized) {
                return Optional.fromNullable((Object)this.distribution.build());
            }
            return Optional.absent();
        }
    }
}

