/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.server.computation.task.projectanalysis.filemove;

import com.google.common.base.MoreObjects;
import com.google.common.base.Splitter;
import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.FluentIterable;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Multimap;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.CheckForNull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.Immutable;
import org.sonar.api.utils.log.Logger;
import org.sonar.api.utils.log.Loggers;
import org.sonar.core.hash.SourceLinesHashesComputer;
import org.sonar.core.util.CloseableIterator;
import org.sonar.db.DbClient;
import org.sonar.db.DbSession;
import org.sonar.db.component.ComponentTreeQuery;
import org.sonar.db.source.FileSourceDto;
import org.sonar.server.computation.task.projectanalysis.analysis.AnalysisMetadataHolder;
import org.sonar.server.computation.task.projectanalysis.component.Component;
import org.sonar.server.computation.task.projectanalysis.component.ComponentVisitor;
import org.sonar.server.computation.task.projectanalysis.component.CrawlerDepthLimit;
import org.sonar.server.computation.task.projectanalysis.component.DepthTraversalTypeAwareCrawler;
import org.sonar.server.computation.task.projectanalysis.component.TreeRootHolder;
import org.sonar.server.computation.task.projectanalysis.component.TypeAwareVisitorAdapter;
import org.sonar.server.computation.task.projectanalysis.filemove.FileSimilarity;
import org.sonar.server.computation.task.projectanalysis.filemove.Match;
import org.sonar.server.computation.task.projectanalysis.filemove.MatchesByScore;
import org.sonar.server.computation.task.projectanalysis.filemove.MovedFilesRepository;
import org.sonar.server.computation.task.projectanalysis.filemove.MutableMovedFilesRepository;
import org.sonar.server.computation.task.projectanalysis.filemove.ScoreMatrix;
import org.sonar.server.computation.task.projectanalysis.source.SourceLinesRepository;
import org.sonar.server.computation.task.step.ComputationStep;

public class FileMoveDetectionStep
implements ComputationStep {
    protected static final int MIN_REQUIRED_SCORE = 85;
    private static final Logger LOG = Loggers.get(FileMoveDetectionStep.class);
    private static final List<String> FILE_QUALIFIERS = Arrays.asList("FIL", "UTS");
    private static final Splitter LINES_HASHES_SPLITTER = Splitter.on((char)'\n');
    private final AnalysisMetadataHolder analysisMetadataHolder;
    private final TreeRootHolder rootHolder;
    private final DbClient dbClient;
    private final SourceLinesRepository sourceLinesRepository;
    private final FileSimilarity fileSimilarity;
    private final MutableMovedFilesRepository movedFilesRepository;

    public FileMoveDetectionStep(AnalysisMetadataHolder analysisMetadataHolder, TreeRootHolder rootHolder, DbClient dbClient, SourceLinesRepository sourceLinesRepository, FileSimilarity fileSimilarity, MutableMovedFilesRepository movedFilesRepository) {
        this.analysisMetadataHolder = analysisMetadataHolder;
        this.rootHolder = rootHolder;
        this.dbClient = dbClient;
        this.sourceLinesRepository = sourceLinesRepository;
        this.fileSimilarity = fileSimilarity;
        this.movedFilesRepository = movedFilesRepository;
    }

    @Override
    public String getDescription() {
        return "Detect file moves";
    }

    @Override
    public void execute() {
        if (this.analysisMetadataHolder.isFirstAnalysis()) {
            LOG.debug("First analysis. Do nothing.");
            return;
        }
        Map<String, DbComponent> dbFilesByKey = this.getDbFilesByKey();
        if (dbFilesByKey.isEmpty()) {
            LOG.debug("Previous snapshot has no file. Do nothing.");
            return;
        }
        Map<String, Component> reportFilesByKey = FileMoveDetectionStep.getReportFilesByKey(this.rootHolder.getRoot());
        if (reportFilesByKey.isEmpty()) {
            LOG.debug("No files in report. Do nothing.");
            return;
        }
        ImmutableSet addedFileKeys = ImmutableSet.copyOf((Collection)Sets.difference(reportFilesByKey.keySet(), dbFilesByKey.keySet()));
        ImmutableSet removedFileKeys = ImmutableSet.copyOf((Collection)Sets.difference(dbFilesByKey.keySet(), reportFilesByKey.keySet()));
        if (addedFileKeys.isEmpty() || removedFileKeys.isEmpty()) {
            LOG.debug("Either no files added or no files removed. Do nothing.");
            return;
        }
        Map<String, FileSimilarity.File> reportFileSourcesByKey = this.getReportFileSourcesByKey(reportFilesByKey, (Set<String>)addedFileKeys);
        ScoreMatrix scoreMatrix = this.computeScoreMatrix(dbFilesByKey, (Set<String>)removedFileKeys, reportFileSourcesByKey);
        FileMoveDetectionStep.printIfDebug(scoreMatrix);
        if (scoreMatrix.getMaxScore() < 85) {
            LOG.debug("max score in matrix is less than min required score (%s). Do nothing.", (Object)85);
            return;
        }
        MatchesByScore matchesByScore = MatchesByScore.create(scoreMatrix);
        ElectedMatches electedMatches = FileMoveDetectionStep.electMatches((Set<String>)removedFileKeys, reportFileSourcesByKey, matchesByScore);
        this.registerMatches(dbFilesByKey, reportFilesByKey, electedMatches);
    }

    private void registerMatches(Map<String, DbComponent> dbFilesByKey, Map<String, Component> reportFilesByKey, ElectedMatches electedMatches) {
        for (Match validatedMatch : electedMatches) {
            this.movedFilesRepository.setOriginalFile(reportFilesByKey.get(validatedMatch.getReportKey()), FileMoveDetectionStep.toOriginalFile(dbFilesByKey.get(validatedMatch.getDbKey())));
            LOG.debug("File move found: {}", (Object)validatedMatch);
        }
    }

    private Map<String, DbComponent> getDbFilesByKey() {
        try (DbSession dbSession = this.dbClient.openSession(false);){
            List componentDtos = this.dbClient.componentDao().selectDescendants(dbSession, ComponentTreeQuery.builder().setBaseUuid(this.rootHolder.getRoot().getUuid()).setQualifiers(FILE_QUALIFIERS).setStrategy(ComponentTreeQuery.Strategy.LEAVES).build());
            ImmutableMap immutableMap = FluentIterable.from((Iterable)componentDtos).transform(componentDto -> new DbComponent(componentDto.getId(), componentDto.getDbKey(), componentDto.uuid(), componentDto.path())).uniqueIndex(DbComponent::getKey);
            return immutableMap;
        }
    }

    private static Map<String, Component> getReportFilesByKey(Component root) {
        final ImmutableMap.Builder builder = ImmutableMap.builder();
        new DepthTraversalTypeAwareCrawler(new TypeAwareVisitorAdapter(CrawlerDepthLimit.FILE, ComponentVisitor.Order.POST_ORDER){

            @Override
            public void visitFile(Component file) {
                builder.put((Object)file.getKey(), (Object)file);
            }
        }).visit(root);
        return builder.build();
    }

    private Map<String, FileSimilarity.File> getReportFileSourcesByKey(Map<String, Component> reportFilesByKey, Set<String> addedFileKeys) {
        ImmutableMap.Builder builder = ImmutableMap.builder();
        for (String fileKey : addedFileKeys) {
            Component component = reportFilesByKey.get(fileKey);
            SourceLinesHashesComputer linesHashesComputer = new SourceLinesHashesComputer();
            try (CloseableIterator<String> lineIterator = this.sourceLinesRepository.readLines(component);){
                while (lineIterator.hasNext()) {
                    String line = (String)lineIterator.next();
                    linesHashesComputer.addLine(line);
                }
            }
            builder.put((Object)fileKey, (Object)new FileSimilarity.File(component.getReportAttributes().getPath(), linesHashesComputer.getLineHashes()));
        }
        return builder.build();
    }

    private ScoreMatrix computeScoreMatrix(Map<String, DbComponent> dtosByKey, Set<String> dbFileKeys, Map<String, FileSimilarity.File> reportFileSourcesByKey) {
        int[][] scoreMatrix = new int[dbFileKeys.size()][reportFileSourcesByKey.size()];
        int maxScore = 0;
        try (DbSession dbSession = this.dbClient.openSession(false);){
            int dbFileIndex = 0;
            for (String removedFileKey : dbFileKeys) {
                FileSimilarity.File fileInDb = this.getFile(dbSession, dtosByKey.get(removedFileKey));
                if (fileInDb == null) continue;
                int reportFileIndex = 0;
                for (Map.Entry<String, FileSimilarity.File> reportFileSourceAndKey : reportFileSourcesByKey.entrySet()) {
                    int score;
                    FileSimilarity.File unmatchedFile = reportFileSourceAndKey.getValue();
                    scoreMatrix[dbFileIndex][reportFileIndex] = score = this.fileSimilarity.score(fileInDb, unmatchedFile);
                    if (score > maxScore) {
                        maxScore = score;
                    }
                    ++reportFileIndex;
                }
                ++dbFileIndex;
            }
        }
        return new ScoreMatrix(dbFileKeys, reportFileSourcesByKey, scoreMatrix, maxScore);
    }

    @CheckForNull
    private FileSimilarity.File getFile(DbSession dbSession, DbComponent dbComponent) {
        if (dbComponent.getPath() == null) {
            return null;
        }
        FileSourceDto fileSourceDto = this.dbClient.fileSourceDao().selectSourceByFileUuid(dbSession, dbComponent.getUuid());
        if (fileSourceDto == null) {
            return null;
        }
        String lineHashes = (String)MoreObjects.firstNonNull((Object)fileSourceDto.getLineHashes(), (Object)"");
        return new FileSimilarity.File(dbComponent.getPath(), LINES_HASHES_SPLITTER.splitToList((CharSequence)lineHashes));
    }

    private static void printIfDebug(ScoreMatrix scoreMatrix) {
        if (LOG.isDebugEnabled()) {
            LOG.debug("ScoreMatrix:\n" + scoreMatrix.toCsv(';'));
        }
    }

    private static ElectedMatches electMatches(Set<String> dbFileKeys, Map<String, FileSimilarity.File> reportFileSourcesByKey, MatchesByScore matchesByScore) {
        ElectedMatches electedMatches = new ElectedMatches(matchesByScore, dbFileKeys, reportFileSourcesByKey);
        ArrayListMultimap matchesPerFileForScore = ArrayListMultimap.create();
        matchesByScore.forEach(arg_0 -> FileMoveDetectionStep.lambda$electMatches$1(electedMatches, (Multimap)matchesPerFileForScore, arg_0));
        return electedMatches;
    }

    private static void electMatches(@Nullable List<Match> matches, ElectedMatches electedMatches, Multimap<String, Match> matchesPerFileForScore) {
        if (matches == null) {
            return;
        }
        List<Match> matchesToValidate = electedMatches.filter(matches);
        if (matchesToValidate.isEmpty()) {
            return;
        }
        if (matchesToValidate.size() == 1) {
            Match match = matchesToValidate.get(0);
            electedMatches.add(match);
        } else {
            matchesPerFileForScore.clear();
            for (Match match : matchesToValidate) {
                matchesPerFileForScore.put((Object)match.getDbKey(), (Object)match);
                matchesPerFileForScore.put((Object)match.getReportKey(), (Object)match);
            }
            for (Match match : matchesToValidate) {
                int dbFileMatchesCount = matchesPerFileForScore.get((Object)match.getDbKey()).size();
                int reportFileMatchesCount = matchesPerFileForScore.get((Object)match.getReportKey()).size();
                if (dbFileMatchesCount != 1 || reportFileMatchesCount != 1) continue;
                electedMatches.add(match);
            }
        }
    }

    private static MovedFilesRepository.OriginalFile toOriginalFile(DbComponent dbComponent) {
        return new MovedFilesRepository.OriginalFile(dbComponent.getId(), dbComponent.getUuid(), dbComponent.getKey());
    }

    private static /* synthetic */ void lambda$electMatches$1(ElectedMatches electedMatches, Multimap matchesPerFileForScore, List matches) {
        FileMoveDetectionStep.electMatches(matches, electedMatches, (Multimap<String, Match>)matchesPerFileForScore);
    }

    private static class ElectedMatches
    implements Iterable<Match> {
        private final List<Match> matches;
        private final Set<String> matchedFileKeys;

        public ElectedMatches(MatchesByScore matchesByScore, Set<String> dbFileKeys, Map<String, FileSimilarity.File> reportFileSourcesByKey) {
            this.matches = new ArrayList<Match>(matchesByScore.getSize());
            this.matchedFileKeys = new HashSet<String>(dbFileKeys.size() + reportFileSourcesByKey.size());
        }

        public void add(Match match) {
            this.matches.add(match);
            this.matchedFileKeys.add(match.getDbKey());
            this.matchedFileKeys.add(match.getReportKey());
        }

        public List<Match> filter(Iterable<Match> matches) {
            return FluentIterable.from(matches).filter(this::notAlreadyMatched).toList();
        }

        private boolean notAlreadyMatched(Match input) {
            return !this.matchedFileKeys.contains(input.getDbKey()) && !this.matchedFileKeys.contains(input.getReportKey());
        }

        @Override
        public Iterator<Match> iterator() {
            return this.matches.iterator();
        }
    }

    @Immutable
    private static final class DbComponent {
        private final long id;
        private final String key;
        private final String uuid;
        private final String path;

        private DbComponent(long id, String key, String uuid, String path) {
            this.id = id;
            this.key = key;
            this.uuid = uuid;
            this.path = path;
        }

        public long getId() {
            return this.id;
        }

        public String getKey() {
            return this.key;
        }

        public String getUuid() {
            return this.uuid;
        }

        public String getPath() {
            return this.path;
        }
    }
}

