/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.server.component;

import com.google.common.base.Preconditions;
import java.util.Collection;
import java.util.Optional;
import java.util.Set;
import javax.annotation.Nullable;
import org.sonar.api.resources.ResourceType;
import org.sonar.api.resources.ResourceTypes;
import org.sonar.core.util.stream.MoreCollectors;
import org.sonar.db.DbClient;
import org.sonar.db.DbSession;
import org.sonar.db.component.ComponentDto;
import org.sonar.db.organization.OrganizationDto;
import org.sonar.server.exceptions.NotFoundException;
import org.sonar.server.ws.WsUtils;

public class ComponentFinder {
    private static final String MSG_COMPONENT_ID_OR_KEY_TEMPLATE = "Either '%s' or '%s' must be provided";
    private static final String MSG_PARAMETER_MUST_NOT_BE_EMPTY = "The '%s' parameter must not be empty";
    private static final String LABEL_PROJECT = "Project";
    private static final String LABEL_COMPONENT = "Component";
    private final DbClient dbClient;
    private final ResourceTypes resourceTypes;

    public ComponentFinder(DbClient dbClient, ResourceTypes resourceTypes) {
        this.dbClient = dbClient;
        this.resourceTypes = resourceTypes;
    }

    public ComponentDto getByUuidOrKey(DbSession dbSession, @Nullable String componentUuid, @Nullable String componentKey, ParamNames parameterNames) {
        ComponentFinder.checkByUuidOrKey(componentUuid, componentKey, parameterNames);
        if (componentUuid != null) {
            return this.getByUuid(dbSession, ComponentFinder.checkParamNotEmpty(componentUuid, parameterNames.getUuidParam()));
        }
        return this.getByKey(dbSession, ComponentFinder.checkParamNotEmpty(componentKey, parameterNames.getKeyParam()));
    }

    public ComponentDto getRootComponentByUuidOrKey(DbSession dbSession, @Nullable String componentUuid, @Nullable String componentKey, ParamNames parameterNames) {
        ComponentFinder.checkByUuidOrKey(componentUuid, componentKey, parameterNames);
        if (componentUuid != null) {
            return this.checkIsProject(this.getByUuid(dbSession, ComponentFinder.checkParamNotEmpty(componentUuid, parameterNames.getUuidParam()), LABEL_PROJECT));
        }
        return this.checkIsProject(this.getByKey(dbSession, ComponentFinder.checkParamNotEmpty(componentKey, parameterNames.getKeyParam()), LABEL_PROJECT));
    }

    private static String checkParamNotEmpty(String value, String param) {
        Preconditions.checkArgument((!value.isEmpty() ? 1 : 0) != 0, (String)MSG_PARAMETER_MUST_NOT_BE_EMPTY, (Object[])new Object[]{param});
        return value;
    }

    private static void checkByUuidOrKey(@Nullable String componentUuid, @Nullable String componentKey, ParamNames parameterNames) {
        Preconditions.checkArgument((boolean)(componentUuid != null ^ componentKey != null), (String)MSG_COMPONENT_ID_OR_KEY_TEMPLATE, (Object[])new Object[]{parameterNames.getUuidParam(), parameterNames.getKeyParam()});
    }

    public ComponentDto getByKey(DbSession dbSession, String key) {
        return this.getByKey(dbSession, key, LABEL_COMPONENT);
    }

    private ComponentDto getByKey(DbSession dbSession, String key, String label) {
        return ComponentFinder.checkComponent((com.google.common.base.Optional<ComponentDto>)this.dbClient.componentDao().selectByKey(dbSession, key), "%s key '%s' not found", label, key);
    }

    public ComponentDto getByUuid(DbSession dbSession, String uuid) {
        return this.getByUuid(dbSession, uuid, LABEL_COMPONENT);
    }

    private ComponentDto getByUuid(DbSession dbSession, String uuid, String label) {
        return ComponentFinder.checkComponent((com.google.common.base.Optional<ComponentDto>)this.dbClient.componentDao().selectByUuid(dbSession, uuid), "%s id '%s' not found", label, uuid);
    }

    private static ComponentDto checkComponent(com.google.common.base.Optional<ComponentDto> componentDto, String message, Object ... messageArguments) {
        if (componentDto.isPresent() && ((ComponentDto)componentDto.get()).isEnabled() && ((ComponentDto)componentDto.get()).getMainBranchProjectUuid() == null) {
            return (ComponentDto)componentDto.get();
        }
        throw new NotFoundException(String.format(message, messageArguments));
    }

    public ComponentDto getRootComponentByUuidOrKey(DbSession dbSession, @Nullable String projectUuid, @Nullable String projectKey) {
        ComponentDto project = projectUuid != null ? this.getByUuid(dbSession, projectUuid, LABEL_PROJECT) : this.getByKey(dbSession, projectKey, LABEL_PROJECT);
        this.checkIsProject(project);
        return project;
    }

    private ComponentDto checkIsProject(ComponentDto component) {
        Set<String> rootQualifiers = ComponentFinder.getRootQualifiers(this.resourceTypes);
        WsUtils.checkRequest(component.scope().equals("PRJ") && rootQualifiers.contains(component.qualifier()), String.format("Component '%s' (id: %s) must be a project%s.", component.getDbKey(), component.uuid(), rootQualifiers.contains("VW") ? " or a view" : ""), new Object[0]);
        return component;
    }

    private static Set<String> getRootQualifiers(ResourceTypes resourceTypes) {
        Collection rootTypes = resourceTypes.getRoots();
        return (Set)rootTypes.stream().map(ResourceType::getQualifier).collect(MoreCollectors.toSet((int)rootTypes.size()));
    }

    public OrganizationDto getOrganization(DbSession dbSession, ComponentDto component) {
        String organizationUuid = component.getOrganizationUuid();
        Optional organizationDto = this.dbClient.organizationDao().selectByUuid(dbSession, organizationUuid);
        return (OrganizationDto)WsUtils.checkFoundWithOptional(organizationDto, "Organization with uuid '%s' not found", organizationUuid);
    }

    public ComponentDto getByKeyAndBranch(DbSession dbSession, String key, String branch) {
        Optional componentDto = this.dbClient.componentDao().selectByKeyAndBranch(dbSession, key, branch);
        if (componentDto.isPresent() && ((ComponentDto)componentDto.get()).isEnabled()) {
            return (ComponentDto)componentDto.get();
        }
        throw new NotFoundException(String.format("Component '%s' on branch '%s' not found", key, branch));
    }

    public ComponentDto getByKeyAndOptionalBranch(DbSession dbSession, String key, @Nullable String branch) {
        return branch == null ? this.getByKey(dbSession, key) : this.getByKeyAndBranch(dbSession, key, branch);
    }

    public static enum ParamNames {
        PROJECT_ID_AND_KEY("projectId", "projectKey"),
        PROJECT_UUID_AND_KEY("projectUuid", "projectKey"),
        PROJECT_UUID_AND_PROJECT("projectUuid", "project"),
        UUID_AND_KEY("uuid", "key"),
        ID_AND_KEY("id", "key"),
        COMPONENT_ID_AND_KEY("componentId", "componentKey"),
        BASE_COMPONENT_ID_AND_KEY("baseComponentId", "baseComponentKey"),
        DEVELOPER_ID_AND_KEY("developerId", "developerKey"),
        COMPONENT_ID_AND_COMPONENT("componentId", "component"),
        PROJECT_ID_AND_PROJECT("projectId", "project"),
        PROJECT_ID_AND_FROM("projectId", "from");

        private final String uuidParamName;
        private final String keyParamName;

        private ParamNames(String uuidParamName, String keyParamName) {
            this.uuidParamName = uuidParamName;
            this.keyParamName = keyParamName;
        }

        public String getUuidParam() {
            return this.uuidParamName;
        }

        public String getKeyParam() {
            return this.keyParamName;
        }
    }
}

