/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.server.authentication;

import java.util.Optional;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang.StringUtils;
import org.sonar.server.authentication.Cookies;

public class OAuth2Redirection {
    private static final String REDIRECT_TO_COOKIE = "REDIRECT_TO";
    private static final String RETURN_TO_PARAMETER = "return_to";

    public void create(HttpServletRequest request, HttpServletResponse response) {
        String redirectTo = request.getParameter(RETURN_TO_PARAMETER);
        if (StringUtils.isBlank((String)redirectTo)) {
            return;
        }
        response.addCookie(Cookies.newCookieBuilder(request).setName(REDIRECT_TO_COOKIE).setValue(redirectTo).setHttpOnly(true).setExpiry(-1).build());
    }

    public Optional<String> getAndDelete(HttpServletRequest request, HttpServletResponse response) {
        Optional<Cookie> cookie = Cookies.findCookie(REDIRECT_TO_COOKIE, request);
        if (!cookie.isPresent()) {
            return Optional.empty();
        }
        this.delete(request, response);
        String redirectTo = cookie.get().getValue();
        if (StringUtils.isBlank((String)redirectTo)) {
            return Optional.empty();
        }
        return Optional.of(redirectTo);
    }

    public void delete(HttpServletRequest request, HttpServletResponse response) {
        response.addCookie(Cookies.newCookieBuilder(request).setName(REDIRECT_TO_COOKIE).setValue(null).setHttpOnly(true).setExpiry(0).build());
    }
}

