/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.server.authentication;

import java.util.Optional;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.sonar.db.user.UserDto;
import org.sonar.server.authentication.Authenticators;
import org.sonar.server.authentication.BasicAuthenticator;
import org.sonar.server.authentication.JwtHttpHandler;
import org.sonar.server.authentication.SsoAuthenticator;

public class AuthenticatorsImpl
implements Authenticators {
    private final JwtHttpHandler jwtHttpHandler;
    private final BasicAuthenticator basicAuthenticator;
    private final SsoAuthenticator ssoAuthenticator;

    public AuthenticatorsImpl(JwtHttpHandler jwtHttpHandler, BasicAuthenticator basicAuthenticator, SsoAuthenticator ssoAuthenticator) {
        this.jwtHttpHandler = jwtHttpHandler;
        this.basicAuthenticator = basicAuthenticator;
        this.ssoAuthenticator = ssoAuthenticator;
    }

    @Override
    public Optional<UserDto> authenticate(HttpServletRequest request, HttpServletResponse response) {
        Optional<UserDto> user = this.ssoAuthenticator.authenticate(request, response);
        if (user.isPresent()) {
            return user;
        }
        user = this.jwtHttpHandler.validateToken(request, response);
        if (user.isPresent()) {
            return user;
        }
        return this.basicAuthenticator.authenticate(request);
    }
}

