/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.scanner.task;

import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.sonar.api.task.Task;
import org.sonar.api.task.TaskDefinition;
import org.sonar.api.utils.MessageException;
import org.sonar.core.platform.ComponentContainer;
import org.sonar.scanner.bootstrap.ExtensionInstaller;
import org.sonar.scanner.bootstrap.ExtensionMatcher;
import org.sonar.scanner.bootstrap.ExtensionUtils;
import org.sonar.scanner.bootstrap.GlobalProperties;
import org.sonar.scanner.task.TaskProperties;
import org.sonar.scanner.task.Tasks;

public class TaskContainer
extends ComponentContainer {
    private final Map<String, String> taskProperties;
    private final Object[] components;

    public TaskContainer(ComponentContainer parent, Map<String, String> taskProperties, Object ... components) {
        super(parent);
        this.taskProperties = taskProperties;
        this.components = components;
    }

    protected void doBeforeStart() {
        this.addTaskExtensions();
        this.addCoreComponents();
        for (Object component : this.components) {
            this.add(new Object[]{component});
        }
    }

    private void addCoreComponents() {
        this.add(new Object[]{new TaskProperties(this.taskProperties, ((GlobalProperties)this.getParent().getComponentByType(GlobalProperties.class)).property("sonar.secretKeyPath"))});
    }

    private void addTaskExtensions() {
        ((ExtensionInstaller)this.getComponentByType(ExtensionInstaller.class)).install(this, new TaskExtensionFilter());
    }

    public void doAfterStart() {
        String taskKey = StringUtils.defaultIfEmpty((String)this.taskProperties.get("sonar.task"), (String)"scan");
        this.taskProperties.clear();
        TaskDefinition def = ((Tasks)this.getComponentByType(Tasks.class)).definition(taskKey);
        if (def == null) {
            throw MessageException.of((String)("Task '" + taskKey + "' does not exist. Please use '" + "list" + "' task to see all available tasks."));
        }
        Task task = (Task)this.getComponentByType(def.taskClass());
        if (task == null) {
            throw new IllegalStateException("Task " + taskKey + " is badly defined");
        }
        task.execute();
    }

    static class TaskExtensionFilter
    implements ExtensionMatcher {
        TaskExtensionFilter() {
        }

        @Override
        public boolean accept(Object extension) {
            return ExtensionUtils.isScannerSide(extension) && ExtensionUtils.isInstantiationStrategy(extension, "PER_TASK");
        }
    }
}

