/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.scanner.source;

import org.sonar.api.batch.AnalysisMode;
import org.sonar.api.batch.fs.InputFile;
import org.sonar.api.batch.sensor.highlighting.TypeOfText;
import org.sonar.api.batch.sensor.highlighting.internal.DefaultHighlighting;
import org.sonar.api.batch.sensor.internal.SensorStorage;
import org.sonar.api.source.Highlightable;

public class DefaultHighlightable
implements Highlightable {
    private static final Highlightable.HighlightingBuilder NO_OP_BUILDER = new NoOpHighlightingBuilder();
    private final InputFile inputFile;
    private final SensorStorage sensorStorage;
    private final AnalysisMode analysisMode;

    public DefaultHighlightable(InputFile inputFile, SensorStorage sensorStorage, AnalysisMode analysisMode) {
        this.inputFile = inputFile;
        this.sensorStorage = sensorStorage;
        this.analysisMode = analysisMode;
    }

    public Highlightable.HighlightingBuilder newHighlighting() {
        if (this.analysisMode.isIssues()) {
            return NO_OP_BUILDER;
        }
        DefaultHighlighting defaultHighlighting = new DefaultHighlighting(this.sensorStorage);
        defaultHighlighting.onFile(this.inputFile);
        return new DefaultHighlightingBuilder(defaultHighlighting);
    }

    private static class DefaultHighlightingBuilder
    implements Highlightable.HighlightingBuilder {
        private final DefaultHighlighting defaultHighlighting;

        public DefaultHighlightingBuilder(DefaultHighlighting defaultHighlighting) {
            this.defaultHighlighting = defaultHighlighting;
        }

        public Highlightable.HighlightingBuilder highlight(int startOffset, int endOffset, String typeOfText) {
            TypeOfText type = TypeOfText.forCssClass((String)typeOfText);
            this.defaultHighlighting.highlight(startOffset, endOffset, type);
            return this;
        }

        public Highlightable.HighlightingBuilder highlight(int startLine, int startLineOffset, int endLine, int endLineOffset, String typeOfText) {
            TypeOfText type = TypeOfText.forCssClass((String)typeOfText);
            this.defaultHighlighting.highlight(startLine, startLineOffset, endLine, endLineOffset, type);
            return this;
        }

        public void done() {
            this.defaultHighlighting.save();
        }
    }

    private static final class NoOpHighlightingBuilder
    implements Highlightable.HighlightingBuilder {
        private NoOpHighlightingBuilder() {
        }

        public Highlightable.HighlightingBuilder highlight(int startOffset, int endOffset, String typeOfText) {
            return this;
        }

        public Highlightable.HighlightingBuilder highlight(int startLine, int startLineOffset, int endLine, int endLineOffset, String typeOfText) {
            return this;
        }

        public void done() {
        }
    }
}

