/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.scanner.scan.filesystem;

import com.google.common.base.Preconditions;
import com.google.common.collect.LinkedHashMultimap;
import com.google.common.collect.SetMultimap;
import com.google.common.collect.Table;
import com.google.common.collect.TreeBasedTable;
import java.nio.file.Path;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.SortedSet;
import java.util.TreeSet;
import javax.annotation.CheckForNull;
import org.sonar.api.batch.ScannerSide;
import org.sonar.api.batch.fs.InputComponent;
import org.sonar.api.batch.fs.InputDir;
import org.sonar.api.batch.fs.InputFile;
import org.sonar.api.batch.fs.InputModule;
import org.sonar.api.batch.fs.internal.DefaultInputDir;
import org.sonar.api.batch.fs.internal.DefaultInputFile;
import org.sonar.api.batch.fs.internal.DefaultInputModule;
import org.sonar.api.batch.fs.internal.FileExtensionPredicate;
import org.sonar.api.scan.filesystem.PathResolver;
import org.sonar.scanner.scan.branch.BranchConfiguration;

@ScannerSide
public class InputComponentStore {
    private final SortedSet<String> globalLanguagesCache = new TreeSet<String>();
    private final Map<String, SortedSet<String>> languagesCache = new HashMap<String, SortedSet<String>>();
    private final Map<String, InputFile> globalInputFileCache = new HashMap<String, InputFile>();
    private final Table<String, String, InputFile> inputFileCache = TreeBasedTable.create();
    private final Map<String, InputDir> globalInputDirCache = new HashMap<String, InputDir>();
    private final Table<String, String, InputDir> inputDirCache = TreeBasedTable.create();
    private final Map<String, InputModule> inputModuleCache = new HashMap<String, InputModule>();
    private final Map<String, InputComponent> inputComponents = new HashMap<String, InputComponent>();
    private final SetMultimap<String, InputFile> filesByNameCache = LinkedHashMultimap.create();
    private final SetMultimap<String, InputFile> filesByExtensionCache = LinkedHashMultimap.create();
    private final InputModule root;
    private final BranchConfiguration branchConfiguration;

    public InputComponentStore(DefaultInputModule root, BranchConfiguration branchConfiguration) {
        this.root = root;
        this.branchConfiguration = branchConfiguration;
        this.put(root);
    }

    public Collection<InputComponent> all() {
        return this.inputComponents.values();
    }

    public Iterable<DefaultInputFile> allFilesToPublish() {
        return this.inputFileCache.values().stream().map(f -> (DefaultInputFile)f).filter(DefaultInputFile::isPublished).filter(f -> !this.branchConfiguration.isShortLivingBranch() || f.status() != InputFile.Status.SAME)::iterator;
    }

    public Iterable<InputFile> allFiles() {
        return this.inputFileCache.values();
    }

    public Iterable<InputDir> allDirs() {
        return this.inputDirCache.values();
    }

    public InputComponent getByKey(String key) {
        return this.inputComponents.get(key);
    }

    public InputModule root() {
        return this.root;
    }

    public Iterable<InputFile> filesByModule(String moduleKey) {
        return this.inputFileCache.row((Object)moduleKey).values();
    }

    public Iterable<InputDir> dirsByModule(String moduleKey) {
        return this.inputDirCache.row((Object)moduleKey).values();
    }

    public InputComponentStore removeModule(String moduleKey) {
        this.inputFileCache.row((Object)moduleKey).clear();
        this.inputDirCache.row((Object)moduleKey).clear();
        return this;
    }

    public InputComponentStore remove(InputFile inputFile) {
        DefaultInputFile file = (DefaultInputFile)inputFile;
        this.inputFileCache.remove((Object)file.moduleKey(), (Object)file.getModuleRelativePath());
        return this;
    }

    public InputComponentStore remove(InputDir inputDir) {
        DefaultInputDir dir = (DefaultInputDir)inputDir;
        this.inputDirCache.remove((Object)dir.moduleKey(), (Object)inputDir.relativePath());
        return this;
    }

    public InputComponentStore put(InputFile inputFile) {
        DefaultInputFile file = (DefaultInputFile)inputFile;
        this.addToLanguageCache(file);
        this.inputFileCache.put((Object)file.moduleKey(), (Object)file.getModuleRelativePath(), (Object)inputFile);
        this.globalInputFileCache.put(file.getProjectRelativePath(), inputFile);
        this.inputComponents.put(inputFile.key(), (InputComponent)inputFile);
        this.filesByNameCache.put((Object)inputFile.filename(), (Object)inputFile);
        this.filesByExtensionCache.put((Object)FileExtensionPredicate.getExtension((InputFile)inputFile), (Object)inputFile);
        return this;
    }

    private void addToLanguageCache(DefaultInputFile inputFile) {
        String language = inputFile.language();
        if (language != null) {
            this.globalLanguagesCache.add(language);
            this.languagesCache.computeIfAbsent(inputFile.moduleKey(), k -> new TreeSet()).add(language);
        }
    }

    public InputComponentStore put(InputDir inputDir) {
        DefaultInputDir dir = (DefaultInputDir)inputDir;
        this.inputDirCache.put((Object)dir.moduleKey(), (Object)inputDir.relativePath(), (Object)inputDir);
        this.globalInputDirCache.put(this.getProjectRelativePath(dir), inputDir);
        this.inputComponents.put(inputDir.key(), (InputComponent)inputDir);
        return this;
    }

    private String getProjectRelativePath(DefaultInputDir dir) {
        return (String)PathResolver.relativize((Path)this.getProjectBaseDir(), (Path)dir.path()).orElseThrow(() -> new IllegalStateException("Dir " + dir.path() + " should be relative to project baseDir"));
    }

    private Path getProjectBaseDir() {
        return ((DefaultInputModule)this.root).getBaseDir();
    }

    @CheckForNull
    public InputFile getFile(String moduleKey, String relativePath) {
        return (InputFile)this.inputFileCache.get((Object)moduleKey, (Object)relativePath);
    }

    @CheckForNull
    public InputFile getFile(String relativePath) {
        return this.globalInputFileCache.get(relativePath);
    }

    @CheckForNull
    public InputDir getDir(String moduleKey, String relativePath) {
        return (InputDir)this.inputDirCache.get((Object)moduleKey, (Object)relativePath);
    }

    @CheckForNull
    public InputDir getDir(String relativePath) {
        return this.globalInputDirCache.get(relativePath);
    }

    @CheckForNull
    public InputModule getModule(String moduleKeyWithBranch) {
        return this.inputModuleCache.get(moduleKeyWithBranch);
    }

    public void put(DefaultInputModule inputModule) {
        String key = inputModule.key();
        String keyWithBranch = inputModule.getKeyWithBranch();
        Preconditions.checkNotNull((Object)inputModule);
        Preconditions.checkState((!this.inputComponents.containsKey(key) ? 1 : 0) != 0, (String)"Module '%s' already indexed", (Object[])new Object[]{key});
        Preconditions.checkState((!this.inputModuleCache.containsKey(keyWithBranch) ? 1 : 0) != 0, (String)"Module '%s' already indexed", (Object[])new Object[]{keyWithBranch});
        this.inputComponents.put(key, (InputComponent)inputModule);
        this.inputModuleCache.put(keyWithBranch, (InputModule)inputModule);
    }

    public Iterable<InputFile> getFilesByName(String filename) {
        return this.filesByNameCache.get((Object)filename);
    }

    public Iterable<InputFile> getFilesByExtension(String extension) {
        return this.filesByExtensionCache.get((Object)extension);
    }

    public SortedSet<String> getLanguages() {
        return this.globalLanguagesCache;
    }

    public SortedSet<String> getLanguages(String moduleKey) {
        return this.languagesCache.getOrDefault(moduleKey, Collections.emptySortedSet());
    }
}

