/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.scanner.scan.filesystem;

import java.nio.file.Path;
import org.apache.commons.lang.ArrayUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.sonar.api.batch.ScannerSide;
import org.sonar.api.batch.fs.InputFile;
import org.sonar.api.batch.fs.internal.PathPattern;
import org.sonar.api.scan.filesystem.FileExclusions;

@ScannerSide
public class ExclusionFilters {
    private static final Logger LOG = LoggerFactory.getLogger(ExclusionFilters.class);
    private final FileExclusions exclusionSettings;
    private PathPattern[] mainInclusions;
    private PathPattern[] mainExclusions;
    private PathPattern[] testInclusions;
    private PathPattern[] testExclusions;

    public ExclusionFilters(FileExclusions exclusions) {
        this.exclusionSettings = exclusions;
    }

    public void prepare() {
        this.mainInclusions = this.prepareMainInclusions();
        this.mainExclusions = this.prepareMainExclusions();
        this.testInclusions = this.prepareTestInclusions();
        this.testExclusions = this.prepareTestExclusions();
        ExclusionFilters.log("Included sources: ", this.mainInclusions);
        ExclusionFilters.log("Excluded sources: ", this.mainExclusions);
        ExclusionFilters.log("Included tests: ", this.testInclusions);
        ExclusionFilters.log("Excluded tests: ", this.testExclusions);
    }

    public boolean hasPattern() {
        return this.mainInclusions.length > 0 || this.mainExclusions.length > 0 || this.testInclusions.length > 0 || this.testExclusions.length > 0;
    }

    private static void log(String title, PathPattern[] patterns) {
        if (patterns.length > 0) {
            LOG.info(title);
            for (PathPattern pattern : patterns) {
                LOG.info("  {}", (Object)pattern);
            }
        }
    }

    public boolean accept(Path absolutePath, Path relativePath, InputFile.Type type) {
        PathPattern[] exclusionPatterns;
        PathPattern[] inclusionPatterns;
        if (InputFile.Type.MAIN == type) {
            inclusionPatterns = this.mainInclusions;
            exclusionPatterns = this.mainExclusions;
        } else if (InputFile.Type.TEST == type) {
            inclusionPatterns = this.testInclusions;
            exclusionPatterns = this.testExclusions;
        } else {
            throw new IllegalArgumentException("Unknown file type: " + type);
        }
        if (inclusionPatterns.length > 0) {
            boolean matchInclusion = false;
            PathPattern[] pathPatternArray = inclusionPatterns;
            int n = pathPatternArray.length;
            for (int i = 0; i < n; ++i) {
                PathPattern pattern = pathPatternArray[i];
                matchInclusion |= pattern.match(absolutePath, relativePath);
            }
            if (!matchInclusion) {
                return false;
            }
        }
        if (exclusionPatterns.length > 0) {
            for (PathPattern pattern : exclusionPatterns) {
                if (!pattern.match(absolutePath, relativePath)) continue;
                return false;
            }
        }
        return true;
    }

    PathPattern[] prepareMainInclusions() {
        if (this.exclusionSettings.sourceInclusions().length > 0) {
            return PathPattern.create((String[])this.exclusionSettings.sourceInclusions());
        }
        return new PathPattern[0];
    }

    PathPattern[] prepareTestInclusions() {
        return PathPattern.create((String[])this.computeTestInclusions());
    }

    private String[] computeTestInclusions() {
        if (this.exclusionSettings.testInclusions().length > 0) {
            return this.exclusionSettings.testInclusions();
        }
        return ArrayUtils.EMPTY_STRING_ARRAY;
    }

    PathPattern[] prepareMainExclusions() {
        String[] patterns = (String[])ArrayUtils.addAll((Object[])this.exclusionSettings.sourceExclusions(), (Object[])this.computeTestInclusions());
        return PathPattern.create((String[])patterns);
    }

    PathPattern[] prepareTestExclusions() {
        return PathPattern.create((String[])this.exclusionSettings.testExclusions());
    }
}

