/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.scanner.scan;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Lists;
import java.io.File;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.text.MessageFormat;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.annotation.CheckForNull;
import javax.annotation.Nullable;
import org.apache.commons.lang.ArrayUtils;
import org.apache.commons.lang.StringUtils;
import org.sonar.api.batch.bootstrap.ProjectDefinition;
import org.sonar.api.batch.bootstrap.ProjectReactor;
import org.sonar.api.utils.MessageException;
import org.sonar.api.utils.log.Logger;
import org.sonar.api.utils.log.Loggers;
import org.sonar.api.utils.log.Profiler;
import org.sonar.scanner.analysis.AnalysisProperties;
import org.sonar.scanner.bootstrap.DroppedPropertyChecker;
import org.sonar.scanner.config.DefaultConfiguration;
import org.sonar.scanner.util.ScannerUtils;

public class ProjectReactorBuilder {
    private static final String INVALID_VALUE_OF_X_FOR_Y = "Invalid value of {0} for {1}";
    private static final Map<String, String> DROPPED_PROPERTIES = ImmutableMap.of((Object)"sonar.qualitygate", (Object)"It will be ignored.");
    private static final Logger LOG = Loggers.get(ProjectReactorBuilder.class);
    private static final String MODULE_KEY_PROPERTY = "sonar.moduleKey";
    protected static final String PROPERTY_PROJECT_BASEDIR = "sonar.projectBaseDir";
    @Deprecated
    private static final String PROPERTY_PROJECT_BUILDDIR = "sonar.projectBuildDir";
    private static final String PROPERTY_MODULES = "sonar.modules";
    private static final String PROPERTY_SOURCES = "sonar.sources";
    private static final String PROPERTY_TESTS = "sonar.tests";
    private static final String[] MANDATORY_PROPERTIES_FOR_SIMPLE_PROJECT = new String[]{"sonar.projectBaseDir", "sonar.projectKey", "sonar.sources"};
    private static final String[] MANDATORY_PROPERTIES_FOR_MULTIMODULE_PROJECT = new String[]{"sonar.projectBaseDir", "sonar.projectKey"};
    private static final String[] MANDATORY_PROPERTIES_FOR_CHILD = new String[]{"sonar.moduleKey"};
    private static final List<String> NON_HERITED_PROPERTIES_FOR_CHILD = Lists.newArrayList((Object[])new String[]{"sonar.projectBaseDir", "sonar.working.directory", "sonar.modules", "sonar.projectDescription"});
    private final AnalysisProperties analysisProps;
    private File rootProjectWorkDir;

    public ProjectReactorBuilder(AnalysisProperties props) {
        this.analysisProps = props;
    }

    public ProjectReactor execute() {
        Profiler profiler = Profiler.create((Logger)LOG).startInfo("Process project properties");
        new DroppedPropertyChecker(this.analysisProps.properties(), DROPPED_PROPERTIES).checkDroppedProperties();
        HashMap<String, Map<String, String>> propertiesByModuleIdPath = new HashMap<String, Map<String, String>>();
        ProjectReactorBuilder.extractPropertiesByModule(propertiesByModuleIdPath, "", "", this.analysisProps.properties());
        ProjectDefinition rootProject = this.defineRootProject((Map)propertiesByModuleIdPath.get(""), null);
        this.rootProjectWorkDir = rootProject.getWorkDir();
        this.defineChildren(rootProject, propertiesByModuleIdPath, "");
        ProjectReactorBuilder.cleanAndCheckProjectDefinitions(rootProject);
        this.analysisProps.properties().putAll((Map)propertiesByModuleIdPath.get(""));
        profiler.stopDebug();
        return new ProjectReactor(rootProject);
    }

    private static void extractPropertiesByModule(Map<String, Map<String, String>> propertiesByModuleIdPath, String currentModuleId, String currentModuleIdPath, Map<String, String> parentProperties) {
        if (propertiesByModuleIdPath.containsKey(currentModuleIdPath)) {
            throw MessageException.of((String)String.format("Two modules have the same id: '%s'. Each module must have a unique id.", currentModuleId));
        }
        HashMap<String, String> currentModuleProperties = new HashMap<String, String>();
        String prefix = !currentModuleId.isEmpty() ? currentModuleId + "." : "";
        int prefixLength = prefix.length();
        Iterator<Map.Entry<String, String>> it = parentProperties.entrySet().iterator();
        while (it.hasNext()) {
            Map.Entry<String, String> e = it.next();
            String key = e.getKey();
            if (!key.startsWith(prefix)) continue;
            currentModuleProperties.put(key.substring(prefixLength), e.getValue());
            it.remove();
        }
        Object[] moduleIds = ProjectReactorBuilder.getListFromProperty(currentModuleProperties, PROPERTY_MODULES);
        Arrays.sort(moduleIds);
        ArrayUtils.reverse((Object[])moduleIds);
        propertiesByModuleIdPath.put(currentModuleIdPath, currentModuleProperties);
        for (Object moduleId : moduleIds) {
            if ("sonar".equals(moduleId)) {
                throw MessageException.of((String)"'sonar' is not a valid module id. Please check property 'sonar.modules'.");
            }
            Object subModuleIdPath = currentModuleIdPath.isEmpty() ? moduleId : currentModuleIdPath + "." + (String)moduleId;
            ProjectReactorBuilder.extractPropertiesByModule(propertiesByModuleIdPath, (String)moduleId, (String)subModuleIdPath, currentModuleProperties);
        }
    }

    protected ProjectDefinition defineRootProject(Map<String, String> rootProperties, @Nullable ProjectDefinition parent) {
        File workDir;
        if (rootProperties.containsKey(PROPERTY_MODULES)) {
            ProjectReactorBuilder.checkMandatoryProperties(rootProperties, MANDATORY_PROPERTIES_FOR_MULTIMODULE_PROJECT);
        } else {
            ProjectReactorBuilder.checkMandatoryProperties(rootProperties, MANDATORY_PROPERTIES_FOR_SIMPLE_PROJECT);
        }
        File baseDir = new File(rootProperties.get(PROPERTY_PROJECT_BASEDIR));
        String projectKey = rootProperties.get("sonar.projectKey");
        if (parent == null) {
            ProjectReactorBuilder.validateDirectories(rootProperties, baseDir, projectKey);
            workDir = this.initRootProjectWorkDir(baseDir, rootProperties);
        } else {
            workDir = this.initModuleWorkDir(baseDir, rootProperties);
        }
        return ProjectDefinition.create().setProperties(rootProperties).setBaseDir(baseDir).setWorkDir(workDir).setBuildDir(ProjectReactorBuilder.initModuleBuildDir(baseDir, rootProperties));
    }

    @VisibleForTesting
    protected File initRootProjectWorkDir(File baseDir, Map<String, String> rootProperties) {
        String workDir = rootProperties.get("sonar.working.directory");
        if (StringUtils.isBlank((String)workDir)) {
            return new File(baseDir, ".sonar");
        }
        File customWorkDir = new File(workDir);
        if (customWorkDir.isAbsolute()) {
            return customWorkDir;
        }
        return new File(baseDir, customWorkDir.getPath());
    }

    @VisibleForTesting
    protected File initModuleWorkDir(File moduleBaseDir, Map<String, String> moduleProperties) {
        String workDir = moduleProperties.get("sonar.working.directory");
        if (StringUtils.isBlank((String)workDir)) {
            return new File(this.rootProjectWorkDir, ScannerUtils.cleanKeyForFilename(moduleProperties.get("sonar.projectKey")));
        }
        File customWorkDir = new File(workDir);
        if (customWorkDir.isAbsolute()) {
            return customWorkDir;
        }
        return new File(moduleBaseDir, customWorkDir.getPath());
    }

    @CheckForNull
    private static File initModuleBuildDir(File moduleBaseDir, Map<String, String> moduleProperties) {
        String buildDir = moduleProperties.get(PROPERTY_PROJECT_BUILDDIR);
        if (StringUtils.isBlank((String)buildDir)) {
            return null;
        }
        File customBuildDir = new File(buildDir);
        if (customBuildDir.isAbsolute()) {
            return customBuildDir;
        }
        return new File(moduleBaseDir, customBuildDir.getPath());
    }

    private void defineChildren(ProjectDefinition parentProject, Map<String, Map<String, String>> propertiesByModuleIdPath, String parentModuleIdPath) {
        Map parentProps = parentProject.properties();
        if (parentProps.containsKey(PROPERTY_MODULES)) {
            for (String moduleId : ProjectReactorBuilder.getListFromProperty(parentProps, PROPERTY_MODULES)) {
                String moduleIdPath = parentModuleIdPath.isEmpty() ? moduleId : parentModuleIdPath + "." + moduleId;
                Map<String, String> moduleProps = propertiesByModuleIdPath.get(moduleIdPath);
                ProjectDefinition childProject = this.loadChildProject(parentProject, moduleProps, moduleId);
                ProjectReactorBuilder.checkUniquenessOfChildKey(childProject, parentProject);
                this.defineChildren(childProject, propertiesByModuleIdPath, moduleIdPath);
                parentProject.addSubProject(childProject);
            }
        }
    }

    protected ProjectDefinition loadChildProject(ProjectDefinition parentProject, Map<String, String> moduleProps, String moduleId) {
        File baseDir;
        if (moduleProps.containsKey(PROPERTY_PROJECT_BASEDIR)) {
            baseDir = ProjectReactorBuilder.resolvePath(parentProject.getBaseDir(), moduleProps.get(PROPERTY_PROJECT_BASEDIR));
            ProjectReactorBuilder.setProjectBaseDir(baseDir, moduleProps, moduleId);
        } else {
            baseDir = new File(parentProject.getBaseDir(), moduleId);
            ProjectReactorBuilder.setProjectBaseDir(baseDir, moduleProps, moduleId);
        }
        ProjectReactorBuilder.setModuleKeyAndNameIfNotDefined(moduleProps, moduleId, parentProject.getKey());
        ProjectReactorBuilder.checkMandatoryProperties(moduleProps, MANDATORY_PROPERTIES_FOR_CHILD);
        ProjectReactorBuilder.validateDirectories(moduleProps, baseDir, moduleId);
        ProjectReactorBuilder.mergeParentProperties(moduleProps, parentProject.properties());
        return this.defineRootProject(moduleProps, parentProject);
    }

    @VisibleForTesting
    protected static void setModuleKeyAndNameIfNotDefined(Map<String, String> childProps, String moduleId, String parentKey) {
        if (!childProps.containsKey(MODULE_KEY_PROPERTY)) {
            if (!childProps.containsKey("sonar.projectKey")) {
                childProps.put(MODULE_KEY_PROPERTY, parentKey + ":" + moduleId);
            } else {
                String childKey = childProps.get("sonar.projectKey");
                childProps.put(MODULE_KEY_PROPERTY, parentKey + ":" + childKey);
            }
        }
        if (!childProps.containsKey("sonar.projectName")) {
            childProps.put("sonar.projectName", moduleId);
        }
        childProps.put("sonar.projectKey", childProps.get(MODULE_KEY_PROPERTY));
    }

    @VisibleForTesting
    protected static void checkUniquenessOfChildKey(ProjectDefinition childProject, ProjectDefinition parentProject) {
        for (ProjectDefinition definition : parentProject.getSubProjects()) {
            if (!definition.getKey().equals(childProject.getKey())) continue;
            throw MessageException.of((String)("Project '" + parentProject.getKey() + "' can't have 2 modules with the following key: " + childProject.getKey()));
        }
    }

    protected static void setProjectBaseDir(File baseDir, Map<String, String> childProps, String moduleId) {
        if (!baseDir.isDirectory()) {
            throw MessageException.of((String)("The base directory of the module '" + moduleId + "' does not exist: " + baseDir.getAbsolutePath()));
        }
        childProps.put(PROPERTY_PROJECT_BASEDIR, baseDir.getAbsolutePath());
    }

    @VisibleForTesting
    protected static void checkMandatoryProperties(Map<String, String> props, String[] mandatoryProps) {
        StringBuilder missing = new StringBuilder();
        for (String mandatoryProperty : mandatoryProps) {
            if (props.containsKey(mandatoryProperty)) continue;
            if (missing.length() > 0) {
                missing.append(", ");
            }
            missing.append(mandatoryProperty);
        }
        String moduleKey = StringUtils.defaultIfBlank((String)props.get(MODULE_KEY_PROPERTY), (String)props.get("sonar.projectKey"));
        if (missing.length() != 0) {
            throw MessageException.of((String)("You must define the following mandatory properties for '" + (moduleKey == null ? "Unknown" : moduleKey) + "': " + missing));
        }
    }

    protected static void validateDirectories(Map<String, String> props, File baseDir, String projectId) {
        if (!props.containsKey(PROPERTY_MODULES)) {
            String[] testPaths = ProjectReactorBuilder.getListFromProperty(props, PROPERTY_TESTS);
            ProjectReactorBuilder.checkExistenceOfPaths(projectId, baseDir, testPaths, PROPERTY_TESTS);
        }
    }

    @VisibleForTesting
    protected static void cleanAndCheckProjectDefinitions(ProjectDefinition project) {
        if (project.getSubProjects().isEmpty()) {
            ProjectReactorBuilder.cleanAndCheckModuleProperties(project);
        } else {
            ProjectReactorBuilder.logMissingSourcesAndTests(project);
            for (ProjectDefinition module : project.getSubProjects()) {
                ProjectReactorBuilder.cleanAndCheckProjectDefinitions(module);
            }
        }
    }

    private static void logMissingSourcesAndTests(ProjectDefinition project) {
        Map properties = project.properties();
        File baseDir = project.getBaseDir();
        ProjectReactorBuilder.logMissingPaths("source", baseDir, ProjectReactorBuilder.getListFromProperty(properties, PROPERTY_SOURCES));
        ProjectReactorBuilder.logMissingPaths("test", baseDir, ProjectReactorBuilder.getListFromProperty(properties, PROPERTY_TESTS));
    }

    private static void logMissingPaths(String label, File baseDir, String[] paths) {
        for (String path : paths) {
            File file = ProjectReactorBuilder.resolvePath(baseDir, path);
            if (file.exists()) continue;
            LOG.debug("Path '{}' does not exist, will not be used as {}", (Object)file, (Object)label);
        }
    }

    @VisibleForTesting
    protected static void cleanAndCheckModuleProperties(ProjectDefinition project) {
        Map properties = project.properties();
        String[] sourcePaths = ProjectReactorBuilder.getListFromProperty(properties, PROPERTY_SOURCES);
        ProjectReactorBuilder.checkExistenceOfPaths(project.getKey(), project.getBaseDir(), sourcePaths, PROPERTY_SOURCES);
    }

    @VisibleForTesting
    protected static void mergeParentProperties(Map<String, String> childProps, Map<String, String> parentProps) {
        for (Map.Entry<String, String> entry : parentProps.entrySet()) {
            String key = entry.getKey();
            if (childProps.containsKey(key) && !childProps.get(key).equals(entry.getValue()) || NON_HERITED_PROPERTIES_FOR_CHILD.contains(key)) continue;
            childProps.put(entry.getKey(), entry.getValue());
        }
    }

    @VisibleForTesting
    protected static void checkExistenceOfPaths(String moduleRef, File baseDir, String[] paths, String propName) {
        for (String path : paths) {
            File sourceFolder = ProjectReactorBuilder.resolvePath(baseDir, path);
            if (sourceFolder.exists()) continue;
            LOG.error(MessageFormat.format(INVALID_VALUE_OF_X_FOR_Y, propName, moduleRef));
            throw MessageException.of((String)("The folder '" + path + "' does not exist for '" + moduleRef + "' (base directory = " + baseDir.getAbsolutePath() + ")"));
        }
    }

    protected static File resolvePath(File baseDir, String path) {
        Path filePath = Paths.get(path, new String[0]);
        if (!filePath.isAbsolute()) {
            filePath = baseDir.toPath().resolve(path);
        }
        return filePath.normalize().toFile();
    }

    static String[] getListFromProperty(Map<String, String> properties, String key) {
        String propValue = properties.get(key);
        if (propValue != null) {
            return DefaultConfiguration.parseAsCsv(PROPERTY_SOURCES, propValue);
        }
        return new String[0];
    }
}

