/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.scanner.scan;

import com.google.common.base.Preconditions;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import javax.annotation.CheckForNull;
import org.sonar.api.batch.fs.InputComponent;
import org.sonar.api.batch.fs.internal.InputComponentTree;

public class DefaultComponentTree
implements InputComponentTree {
    private Map<InputComponent, InputComponent> parents = new HashMap<InputComponent, InputComponent>();
    private Map<InputComponent, Set<InputComponent>> children = new HashMap<InputComponent, Set<InputComponent>>();

    public void index(InputComponent component, InputComponent parent) {
        Preconditions.checkNotNull((Object)component);
        Preconditions.checkNotNull((Object)parent);
        this.parents.put(component, parent);
        this.children.computeIfAbsent(parent, k -> new LinkedHashSet()).add(component);
    }

    public Collection<InputComponent> getChildren(InputComponent component) {
        return this.children.getOrDefault(component, Collections.emptySet());
    }

    @CheckForNull
    public InputComponent getParent(InputComponent component) {
        return this.parents.get(component);
    }
}

