/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.scanner.rule;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.picocontainer.injectors.ProviderAdapter;
import org.sonar.api.batch.rule.ActiveRules;
import org.sonar.api.batch.rule.internal.ActiveRulesBuilder;
import org.sonar.api.batch.rule.internal.NewActiveRule;
import org.sonar.api.rule.RuleKey;
import org.sonar.api.utils.log.Logger;
import org.sonar.api.utils.log.Loggers;
import org.sonar.api.utils.log.Profiler;
import org.sonar.scanner.rule.ActiveRulesLoader;
import org.sonar.scanner.rule.LoadedActiveRule;
import org.sonar.scanner.rule.ModuleQProfiles;
import org.sonar.scanner.rule.QProfile;

public class ActiveRulesProvider
extends ProviderAdapter {
    private static final Logger LOG = Loggers.get(ActiveRulesProvider.class);
    private static final String LOG_MSG = "Load active rules";
    private ActiveRules singleton = null;

    public ActiveRules provide(ActiveRulesLoader loader, ModuleQProfiles qProfiles) {
        if (this.singleton == null) {
            Profiler profiler = Profiler.create((Logger)LOG).startInfo(LOG_MSG);
            this.singleton = ActiveRulesProvider.load(loader, qProfiles);
            profiler.stopInfo();
        }
        return this.singleton;
    }

    private static ActiveRules load(ActiveRulesLoader loader, ModuleQProfiles qProfiles) {
        Collection<String> qProfileKeys = ActiveRulesProvider.getKeys(qProfiles);
        HashMap<RuleKey, LoadedActiveRule> loadedRulesByKey = new HashMap<RuleKey, LoadedActiveRule>();
        for (String qProfileKey : qProfileKeys) {
            List<LoadedActiveRule> qProfileRules = ActiveRulesProvider.load(loader, qProfileKey);
            for (LoadedActiveRule r : qProfileRules) {
                if (loadedRulesByKey.containsKey(r.getRuleKey())) continue;
                loadedRulesByKey.put(r.getRuleKey(), r);
            }
        }
        return ActiveRulesProvider.transform(loadedRulesByKey.values());
    }

    private static ActiveRules transform(Collection<LoadedActiveRule> loadedRules) {
        ActiveRulesBuilder builder = new ActiveRulesBuilder();
        for (LoadedActiveRule activeRule : loadedRules) {
            NewActiveRule newActiveRule = builder.create(activeRule.getRuleKey());
            newActiveRule.setName(activeRule.getName());
            newActiveRule.setSeverity(activeRule.getSeverity());
            newActiveRule.setCreatedAt(activeRule.getCreatedAt());
            newActiveRule.setLanguage(activeRule.getLanguage());
            newActiveRule.setInternalKey(activeRule.getInternalKey());
            newActiveRule.setTemplateRuleKey(activeRule.getTemplateRuleKey());
            if (activeRule.getParams() != null) {
                for (Map.Entry<String, String> params : activeRule.getParams().entrySet()) {
                    newActiveRule.setParam(params.getKey(), params.getValue());
                }
            }
            newActiveRule.activate();
        }
        return builder.build();
    }

    private static List<LoadedActiveRule> load(ActiveRulesLoader loader, String qProfileKey) {
        return loader.load(qProfileKey);
    }

    private static Collection<String> getKeys(ModuleQProfiles qProfiles) {
        ArrayList<String> keys = new ArrayList<String>(qProfiles.findAll().size());
        for (QProfile qp : qProfiles.findAll()) {
            keys.add(qp.getKey());
        }
        return keys;
    }
}

