/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.scanner.repository;

import org.picocontainer.injectors.ProviderAdapter;
import org.sonar.api.batch.bootstrap.ProjectKey;
import org.sonar.api.utils.log.Logger;
import org.sonar.api.utils.log.Loggers;
import org.sonar.api.utils.log.Profiler;
import org.sonar.scanner.bootstrap.GlobalAnalysisMode;
import org.sonar.scanner.repository.ProjectRepositories;
import org.sonar.scanner.repository.ProjectRepositoriesLoader;
import org.sonar.scanner.scan.branch.BranchConfiguration;

public class ProjectRepositoriesProvider
extends ProviderAdapter {
    private static final Logger LOG = Loggers.get(ProjectRepositoriesProvider.class);
    private static final String LOG_MSG = "Load project repositories";
    private ProjectRepositories project = null;

    public ProjectRepositories provide(ProjectRepositoriesLoader loader, ProjectKey projectKey, GlobalAnalysisMode mode, BranchConfiguration branchConfig) {
        if (this.project == null) {
            boolean isIssuesMode = mode.isIssues();
            Profiler profiler = Profiler.create((Logger)LOG).startInfo(LOG_MSG);
            this.project = loader.load(projectKey.get(), isIssuesMode, branchConfig.branchBase());
            this.checkProject(isIssuesMode);
            profiler.stopInfo();
        }
        return this.project;
    }

    private void checkProject(boolean isIssueMode) {
        if (isIssueMode) {
            if (!this.project.exists()) {
                LOG.warn("Project doesn't exist on the server. All issues will be marked as 'new'.");
            } else if (this.project.lastAnalysisDate() == null) {
                LOG.warn("No analysis has been found on the server for this project. All issues will be marked as 'new'.");
            }
        }
    }
}

