/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.scanner.repository;

import java.io.IOException;
import java.io.InputStream;
import java.util.function.Consumer;
import org.apache.commons.io.IOUtils;
import org.sonar.scanner.bootstrap.ScannerWsClient;
import org.sonar.scanner.protocol.input.ScannerInput;
import org.sonar.scanner.repository.ServerIssuesLoader;
import org.sonar.scanner.util.ScannerUtils;
import org.sonarqube.ws.client.GetRequest;
import org.sonarqube.ws.client.WsRequest;

public class DefaultServerIssuesLoader
implements ServerIssuesLoader {
    private final ScannerWsClient wsClient;

    public DefaultServerIssuesLoader(ScannerWsClient wsClient) {
        this.wsClient = wsClient;
    }

    @Override
    public void load(String componentKey, Consumer<ScannerInput.ServerIssue> consumer) {
        GetRequest getRequest = new GetRequest("/batch/issues.protobuf?key=" + ScannerUtils.encodeForUrl(componentKey));
        InputStream is = this.wsClient.call((WsRequest)getRequest).contentStream();
        DefaultServerIssuesLoader.parseIssues(is, consumer);
    }

    private static void parseIssues(InputStream is, Consumer<ScannerInput.ServerIssue> consumer) {
        try {
            ScannerInput.ServerIssue previousIssue = ScannerInput.ServerIssue.parseDelimitedFrom((InputStream)is);
            while (previousIssue != null) {
                consumer.accept(previousIssue);
                previousIssue = ScannerInput.ServerIssue.parseDelimitedFrom((InputStream)is);
            }
        }
        catch (IOException e) {
            throw new IllegalStateException("Unable to get previous issues", e);
        }
        finally {
            IOUtils.closeQuietly((InputStream)is);
        }
    }
}

