/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.scanner.report;

import com.google.common.collect.Iterables;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import org.sonar.api.batch.fs.InputComponent;
import org.sonar.api.batch.fs.internal.DefaultInputComponent;
import org.sonar.api.test.CoverageBlock;
import org.sonar.api.test.MutableTestCase;
import org.sonar.api.test.MutableTestPlan;
import org.sonar.api.test.TestCase;
import org.sonar.scanner.deprecated.test.DefaultTestable;
import org.sonar.scanner.deprecated.test.TestPlanBuilder;
import org.sonar.scanner.protocol.output.ScannerReport;
import org.sonar.scanner.protocol.output.ScannerReportWriter;
import org.sonar.scanner.report.ReportPublisherStep;
import org.sonar.scanner.scan.filesystem.InputComponentStore;

public class TestExecutionAndCoveragePublisher
implements ReportPublisherStep {
    private final InputComponentStore componentStore;
    private final TestPlanBuilder testPlanBuilder;

    public TestExecutionAndCoveragePublisher(InputComponentStore componentStore, TestPlanBuilder testPlanBuilder) {
        this.componentStore = componentStore;
        this.testPlanBuilder = testPlanBuilder;
    }

    @Override
    public void publish(ScannerReportWriter writer) {
        ScannerReport.Test.Builder testBuilder = ScannerReport.Test.newBuilder();
        ScannerReport.CoverageDetail.Builder builder = ScannerReport.CoverageDetail.newBuilder();
        ScannerReport.CoverageDetail.CoveredFile.Builder coveredBuilder = ScannerReport.CoverageDetail.CoveredFile.newBuilder();
        for (InputComponent c : this.componentStore.all()) {
            DefaultInputComponent component = (DefaultInputComponent)c;
            MutableTestPlan testPlan = this.testPlanBuilder.loadPerspective(MutableTestPlan.class, (InputComponent)component);
            if (testPlan == null || Iterables.isEmpty((Iterable)testPlan.testCases())) continue;
            HashSet testNamesWithCoverage = new HashSet();
            writer.writeTests(component.batchId(), (Iterable)StreamSupport.stream(testPlan.testCases().spliterator(), false).map(testCase -> TestExecutionAndCoveragePublisher.toProtobufTest(testBuilder, testNamesWithCoverage, testCase)).collect(Collectors.toList()));
            writer.writeCoverageDetails(component.batchId(), (Iterable)testNamesWithCoverage.stream().map(testName -> this.toProtobufCoverageDetails(builder, coveredBuilder, testPlan, (String)testName)).collect(Collectors.toList()));
        }
    }

    private ScannerReport.CoverageDetail toProtobufCoverageDetails(ScannerReport.CoverageDetail.Builder builder, ScannerReport.CoverageDetail.CoveredFile.Builder coveredBuilder, MutableTestPlan testPlan, String testName) {
        MutableTestCase testCase = (MutableTestCase)testPlan.testCasesByName(testName).iterator().next();
        builder.clear();
        builder.setTestName(testName);
        for (CoverageBlock block : testCase.coverageBlocks()) {
            coveredBuilder.clear();
            DefaultInputComponent c = (DefaultInputComponent)this.componentStore.getByKey(((DefaultTestable)block.testable()).inputFile().key());
            coveredBuilder.setFileRef(c.batchId());
            Iterator iterator = block.lines().iterator();
            while (iterator.hasNext()) {
                int line = (Integer)iterator.next();
                coveredBuilder.addCoveredLine(line);
            }
            builder.addCoveredFile(coveredBuilder.build());
        }
        return builder.build();
    }

    private static ScannerReport.Test toProtobufTest(ScannerReport.Test.Builder testBuilder, Set<String> testNamesWithCoverage, MutableTestCase testCase) {
        TestCase.Status status;
        String stack;
        String msg;
        Long durationInMs;
        testBuilder.clear();
        testBuilder.setName(testCase.name());
        if (testCase.doesCover()) {
            testNamesWithCoverage.add(testCase.name());
        }
        if ((durationInMs = testCase.durationInMs()) != null) {
            testBuilder.setDurationInMs(durationInMs.longValue());
        }
        if ((msg = testCase.message()) != null) {
            testBuilder.setMsg(msg);
        }
        if ((stack = testCase.stackTrace()) != null) {
            testBuilder.setStacktrace(stack);
        }
        if ((status = testCase.status()) != null) {
            testBuilder.setStatus(ScannerReport.Test.TestStatus.valueOf((String)status.name()));
        }
        return testBuilder.build();
    }
}

