/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.scanner.profiling;

import com.google.common.collect.Maps;
import java.util.EnumMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Properties;
import javax.annotation.Nullable;
import org.sonar.api.resources.Project;
import org.sonar.api.utils.System2;
import org.sonar.scanner.profiling.AbstractTimeProfiling;
import org.sonar.scanner.profiling.ItemProfiling;
import org.sonar.scanner.profiling.Phase;
import org.sonar.scanner.profiling.PhaseProfiling;

public class ModuleProfiling
extends AbstractTimeProfiling {
    private Map<Phase, PhaseProfiling> profilingPerPhase = new EnumMap<Phase, PhaseProfiling>(Phase.class);
    private Map<String, ItemProfiling> profilingPerBatchStep = new LinkedHashMap<String, ItemProfiling>();
    private final Project module;

    public ModuleProfiling(@Nullable Project module, System2 system) {
        super(system);
        this.module = module;
    }

    public String moduleName() {
        if (this.module != null) {
            return this.module.getName();
        }
        return null;
    }

    public PhaseProfiling getProfilingPerPhase(Phase phase) {
        return this.profilingPerPhase.get((Object)phase);
    }

    public ItemProfiling getProfilingPerBatchStep(String stepName) {
        return this.profilingPerBatchStep.get(stepName);
    }

    public void addPhaseProfiling(Phase phase) {
        this.profilingPerPhase.put(phase, PhaseProfiling.create(this.system(), phase));
    }

    public void addBatchStepProfiling(String stepName) {
        this.profilingPerBatchStep.put(stepName, new ItemProfiling(this.system(), stepName));
    }

    public void dump(Properties props) {
        double percent = (double)this.totalTime() / 100.0;
        LinkedHashMap categories = Maps.newLinkedHashMap();
        categories.putAll(this.profilingPerPhase);
        categories.putAll(this.profilingPerBatchStep);
        for (Map.Entry entry : categories.entrySet()) {
            props.setProperty(entry.getKey().toString(), Long.toString(((AbstractTimeProfiling)entry.getValue()).totalTime()));
        }
        for (Map.Entry<Object, Object> entry : ModuleProfiling.sortByDescendingTotalTime(categories).entrySet()) {
            this.println(" * " + entry.getKey() + " execution time: ", percent, (AbstractTimeProfiling)entry.getValue());
        }
        for (Iterator<Map.Entry<Object, Object>> iterator : Phase.values()) {
            if (!this.profilingPerPhase.containsKey(iterator) || !this.getProfilingPerPhase((Phase)((Object)iterator)).hasItems()) continue;
            this.println("");
            this.println(" * " + iterator + " execution time breakdown: ", this.getProfilingPerPhase((Phase)((Object)iterator)));
            this.getProfilingPerPhase((Phase)((Object)iterator)).dump(props);
        }
    }

    public void merge(ModuleProfiling other) {
        super.add(other);
        for (Map.Entry<Phase, PhaseProfiling> entry : other.profilingPerPhase.entrySet()) {
            if (!this.profilingPerPhase.containsKey((Object)entry.getKey())) {
                this.addPhaseProfiling(entry.getKey());
            }
            this.getProfilingPerPhase(entry.getKey()).merge(entry.getValue());
        }
        for (Map.Entry<Object, AbstractTimeProfiling> entry : other.profilingPerBatchStep.entrySet()) {
            if (!this.profilingPerBatchStep.containsKey(entry.getKey())) {
                this.profilingPerBatchStep.put((String)entry.getKey(), new ItemProfiling(this.system(), (String)entry.getKey()));
            }
            this.getProfilingPerBatchStep((String)entry.getKey()).add(entry.getValue());
        }
    }
}

