/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.scanner.postjob;

import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import javax.annotation.Nullable;
import org.sonar.api.batch.AnalysisMode;
import org.sonar.api.batch.fs.InputComponent;
import org.sonar.api.batch.postjob.PostJobContext;
import org.sonar.api.batch.postjob.issue.PostJobIssue;
import org.sonar.api.batch.rule.Severity;
import org.sonar.api.config.Configuration;
import org.sonar.api.config.Settings;
import org.sonar.api.rule.RuleKey;
import org.sonar.scanner.issue.IssueCache;
import org.sonar.scanner.issue.tracking.TrackedIssue;
import org.sonar.scanner.scan.filesystem.InputComponentStore;

public class DefaultPostJobContext
implements PostJobContext {
    private final Configuration config;
    private final IssueCache cache;
    private final AnalysisMode analysisMode;
    private InputComponentStore inputComponentStore;
    private final Settings mutableSettings;

    public DefaultPostJobContext(Configuration config, Settings mutableSettings, IssueCache cache, InputComponentStore inputComponentStore, AnalysisMode analysisMode) {
        this.config = config;
        this.mutableSettings = mutableSettings;
        this.cache = cache;
        this.inputComponentStore = inputComponentStore;
        this.analysisMode = analysisMode;
    }

    public Settings settings() {
        return this.mutableSettings;
    }

    public Configuration config() {
        return this.config;
    }

    public AnalysisMode analysisMode() {
        return this.analysisMode;
    }

    public Iterable<PostJobIssue> issues() {
        if (!this.analysisMode.isIssues()) {
            throw new UnsupportedOperationException("Issues are only available to PostJobs in 'issues' mode.");
        }
        return StreamSupport.stream(this.cache.all().spliterator(), false).filter(new ResolvedPredicate(false)).map(x$0 -> new DefaultIssueWrapper((TrackedIssue)x$0)).collect(Collectors.toList());
    }

    public Iterable<PostJobIssue> resolvedIssues() {
        if (!this.analysisMode.isIssues()) {
            throw new UnsupportedOperationException("Resolved issues are only available to PostJobs in 'issues' mode.");
        }
        return StreamSupport.stream(this.cache.all().spliterator(), false).filter(new ResolvedPredicate(true)).map(x$0 -> new DefaultIssueWrapper((TrackedIssue)x$0)).collect(Collectors.toList());
    }

    private static class ResolvedPredicate
    implements Predicate<TrackedIssue> {
        private final boolean resolved;

        private ResolvedPredicate(boolean resolved) {
            this.resolved = resolved;
        }

        @Override
        public boolean test(@Nullable TrackedIssue issue) {
            if (issue != null) {
                return this.resolved ? issue.resolution() != null : issue.resolution() == null;
            }
            return false;
        }
    }

    private class DefaultIssueWrapper
    implements PostJobIssue {
        private final TrackedIssue wrapped;

        public DefaultIssueWrapper(TrackedIssue wrapped) {
            this.wrapped = wrapped;
        }

        public String key() {
            return this.wrapped.key();
        }

        public RuleKey ruleKey() {
            return this.wrapped.getRuleKey();
        }

        public String componentKey() {
            return this.wrapped.componentKey();
        }

        public InputComponent inputComponent() {
            return DefaultPostJobContext.this.inputComponentStore.getByKey(this.wrapped.componentKey());
        }

        public Integer line() {
            return this.wrapped.startLine();
        }

        public String message() {
            return this.wrapped.getMessage();
        }

        public Severity severity() {
            return Severity.valueOf((String)this.wrapped.severity());
        }

        public boolean isNew() {
            return this.wrapped.isNew();
        }
    }
}

