/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.scanner.phases;

import java.util.Collection;
import org.apache.commons.lang.StringUtils;
import org.sonar.api.batch.Sensor;
import org.sonar.api.batch.events.SensorExecutionHandler;
import org.sonar.api.batch.events.SensorsPhaseHandler;
import org.sonar.api.utils.log.Logger;
import org.sonar.api.utils.log.Loggers;
import org.sonar.api.utils.log.Profiler;
import org.sonar.scanner.bootstrap.ScannerPluginRepository;
import org.sonar.scanner.sensor.SensorWrapper;
import org.sonar.scanner.util.ScannerUtils;

public class PhasesTimeProfiler
implements SensorExecutionHandler,
SensorsPhaseHandler {
    private static final Logger LOG = Loggers.get(PhasesTimeProfiler.class);
    private Profiler profiler = Profiler.create((Logger)LOG);
    private final ScannerPluginRepository pluginRepo;

    public PhasesTimeProfiler(ScannerPluginRepository pluginRepo) {
        this.pluginRepo = pluginRepo;
    }

    public void onSensorsPhase(SensorsPhaseHandler.SensorsPhaseEvent event) {
        if (event.isStart()) {
            LOG.debug("Sensors : {}", (Object)StringUtils.join((Collection)event.getSensors(), (String)" -> "));
        }
    }

    public void onSensorExecution(SensorExecutionHandler.SensorExecutionEvent event) {
        if (event.isStart()) {
            ClassLoader cl = PhasesTimeProfiler.getSensorClassLoader(event.getSensor());
            String pluginKey = this.pluginRepo.getPluginKey(cl);
            String suffix = "";
            if (pluginKey != null) {
                suffix = " [" + pluginKey + "]";
            }
            this.profiler.startInfo("Sensor " + ScannerUtils.describe(event.getSensor()) + suffix);
        } else {
            this.profiler.stopInfo();
        }
    }

    private static ClassLoader getSensorClassLoader(Sensor sensor) {
        if (sensor instanceof SensorWrapper) {
            SensorWrapper wrapper = (SensorWrapper)sensor;
            return wrapper.wrappedSensor().getClass().getClassLoader();
        }
        return sensor.getClass().getClassLoader();
    }
}

