/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.scanner.issue.tracking;

import java.util.Collection;
import java.util.Collections;
import javax.annotation.CheckForNull;
import org.sonar.api.batch.fs.InputFile;
import org.sonar.api.batch.fs.InputPath;
import org.sonar.api.batch.fs.internal.DefaultInputFile;
import org.sonar.api.batch.fs.internal.DefaultInputModule;
import org.sonar.core.component.ComponentKeys;
import org.sonar.scanner.issue.tracking.FileHashes;
import org.sonar.scanner.issue.tracking.ServerLineHashesLoader;

public class SourceHashHolder {
    private final DefaultInputModule module;
    private final DefaultInputFile inputFile;
    private final ServerLineHashesLoader lastSnapshots;
    private FileHashes hashedReference;
    private FileHashes hashedSource;

    public SourceHashHolder(DefaultInputModule module, DefaultInputFile inputFile, ServerLineHashesLoader lastSnapshots) {
        this.module = module;
        this.inputFile = inputFile;
        this.lastSnapshots = lastSnapshots;
    }

    private void initHashes() {
        if (this.hashedSource == null) {
            String serverSideKey;
            String[] lineHashes;
            this.hashedSource = FileHashes.create((InputFile)this.inputFile);
            InputFile.Status status = this.inputFile.status();
            this.hashedReference = status == InputFile.Status.ADDED ? null : (status == InputFile.Status.SAME ? this.hashedSource : ((lineHashes = this.lastSnapshots.getLineHashes(serverSideKey = ComponentKeys.createEffectiveKey((String)this.module.definition().getKeyWithBranch(), (InputPath)this.inputFile))) != null ? FileHashes.create(lineHashes) : null));
        }
    }

    @CheckForNull
    public FileHashes getHashedReference() {
        this.initHashes();
        return this.hashedReference;
    }

    public FileHashes getHashedSource() {
        this.initHashes();
        return this.hashedSource;
    }

    public Collection<Integer> getNewLinesMatching(Integer originLine) {
        FileHashes reference = this.getHashedReference();
        if (reference == null) {
            return Collections.emptySet();
        }
        return this.getHashedSource().getLinesForHash(reference.getHash(originLine));
    }
}

