/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.scanner.issue.tracking;

import org.sonar.scanner.issue.tracking.FileHashes;

public class RollingFileHashes {
    final int[] rollingHashes;

    private RollingFileHashes(int[] hashes) {
        this.rollingHashes = hashes;
    }

    public static RollingFileHashes create(FileHashes hashes, int halfBlockSize) {
        int i;
        int size = hashes.length();
        int[] rollingHashes = new int[size];
        RollingHashCalculator hashCalulator = new RollingHashCalculator(halfBlockSize * 2 + 1);
        for (i = 1; i <= Math.min(size, halfBlockSize + 1); ++i) {
            hashCalulator.add(hashes.getHash(i).hashCode());
        }
        for (i = 1; i <= size; ++i) {
            rollingHashes[i - 1] = hashCalulator.getHash();
            if (i - halfBlockSize > 0) {
                hashCalulator.remove(hashes.getHash(i - halfBlockSize).hashCode());
            }
            if (i + 1 + halfBlockSize <= size) {
                hashCalulator.add(hashes.getHash(i + 1 + halfBlockSize).hashCode());
                continue;
            }
            hashCalulator.add(0);
        }
        return new RollingFileHashes(rollingHashes);
    }

    public int getHash(int line) {
        return this.rollingHashes[line - 1];
    }

    private static class RollingHashCalculator {
        private static final int PRIME_BASE = 31;
        private final int power;
        private int hash;

        public RollingHashCalculator(int size) {
            int pow = 1;
            for (int i = 0; i < size - 1; ++i) {
                pow *= 31;
            }
            this.power = pow;
        }

        public void add(int value) {
            this.hash = this.hash * 31 + value;
        }

        public void remove(int value) {
            this.hash -= this.power * value;
        }

        public int getHash() {
            return this.hash;
        }
    }
}

