/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.scanner.issue.ignore.pattern;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.LinkedHashMultimap;
import com.google.common.collect.Multimap;
import java.util.Collection;
import java.util.Set;
import javax.annotation.CheckForNull;
import javax.annotation.Nullable;
import org.sonar.api.rule.RuleKey;
import org.sonar.scanner.issue.ignore.pattern.IssuePattern;
import org.sonar.scanner.issue.ignore.pattern.LineRange;

public class PatternMatcher {
    private Multimap<String, IssuePattern> excludePatternByComponent = LinkedHashMultimap.create();

    @CheckForNull
    public IssuePattern getMatchingPattern(String componentKey, RuleKey ruleKey, @Nullable Integer line) {
        for (IssuePattern pattern : this.getPatternsForComponent(componentKey)) {
            if (!pattern.match(componentKey, ruleKey, line)) continue;
            return pattern;
        }
        return null;
    }

    @VisibleForTesting
    public Collection<IssuePattern> getPatternsForComponent(String componentKey) {
        return this.excludePatternByComponent.get((Object)componentKey);
    }

    public void addPatternForComponent(String componentKey, IssuePattern pattern) {
        this.excludePatternByComponent.put((Object)componentKey, (Object)pattern.forResource(componentKey));
    }

    public void addPatternToExcludeResource(String componentKey) {
        this.addPatternForComponent(componentKey, new IssuePattern(componentKey, "*"));
    }

    public void addPatternToExcludeLines(String componentKey, Set<LineRange> lineRanges) {
        this.addPatternForComponent(componentKey, new IssuePattern(componentKey, "*", lineRanges));
    }
}

