/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.scanner.issue.ignore.pattern;

import com.google.common.annotations.VisibleForTesting;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import java.util.regex.Pattern;
import org.apache.commons.lang.StringUtils;
import org.sonar.scanner.issue.ignore.pattern.LineRange;

public class PatternDecoder {
    private static final String LINE_RANGE_REGEXP = "\\[((\\d+|\\d+-\\d+),?)*\\]";
    private static final String CONFIG_FORMAT_ERROR_PREFIX = "Exclusions > Issues : Invalid format. ";

    private PatternDecoder() {
    }

    static void checkRegularLineConstraints(String line, String[] fields) {
        if (!PatternDecoder.isResource(fields[0])) {
            throw new IllegalStateException("Exclusions > Issues : Invalid format. The first field does not define a resource pattern: " + line);
        }
        if (!PatternDecoder.isRule(fields[1])) {
            throw new IllegalStateException("Exclusions > Issues : Invalid format. The second field does not define a rule pattern: " + line);
        }
        if (!PatternDecoder.isLinesRange(fields[2])) {
            throw new IllegalStateException("Exclusions > Issues : Invalid format. The third field does not define a range of lines: " + line);
        }
    }

    static void checkDoubleRegexpLineConstraints(String line, String[] fields) {
        if (!PatternDecoder.isRegexp(fields[0])) {
            throw new IllegalStateException("Exclusions > Issues : Invalid format. The first field does not define a regular expression: " + line);
        }
    }

    static void checkWholeFileRegexp(String regexp) {
        if (!PatternDecoder.isRegexp(regexp)) {
            throw new IllegalStateException("Exclusions > Issues : Invalid format. The field does not define a regular expression: " + regexp);
        }
    }

    public static Set<LineRange> decodeRangeOfLines(String field) {
        String[] parts;
        if (StringUtils.equals((String)field, (String)"*")) {
            return Collections.emptySet();
        }
        HashSet<LineRange> lineRanges = new HashSet<LineRange>();
        String s = StringUtils.substringBetween((String)StringUtils.trim((String)field), (String)"[", (String)"]");
        for (String part : parts = StringUtils.split((String)s, (char)',')) {
            if (StringUtils.contains((String)part, (char)'-')) {
                String[] range = StringUtils.split((String)part, (char)'-');
                lineRanges.add(new LineRange(Integer.valueOf(range[0]), Integer.valueOf(range[1])));
                continue;
            }
            lineRanges.add(new LineRange(Integer.valueOf(part), Integer.valueOf(part)));
        }
        return lineRanges;
    }

    @VisibleForTesting
    static boolean isLinesRange(String field) {
        return StringUtils.equals((String)field, (String)"*") || Pattern.matches(LINE_RANGE_REGEXP, field);
    }

    @VisibleForTesting
    static boolean isResource(String field) {
        return StringUtils.isNotBlank((String)field);
    }

    @VisibleForTesting
    static boolean isRule(String field) {
        return StringUtils.isNotBlank((String)field);
    }

    @VisibleForTesting
    static boolean isRegexp(String field) {
        return StringUtils.isNotBlank((String)field);
    }
}

