/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.scanner.issue.ignore;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.sonar.api.scan.issue.filter.FilterableIssue;
import org.sonar.api.scan.issue.filter.IssueFilter;
import org.sonar.api.scan.issue.filter.IssueFilterChain;
import org.sonar.scanner.issue.ignore.pattern.IssuePattern;
import org.sonar.scanner.issue.ignore.pattern.PatternMatcher;

public class IgnoreIssuesFilter
implements IssueFilter {
    private PatternMatcher patternMatcher;
    private static final Logger LOG = LoggerFactory.getLogger(IgnoreIssuesFilter.class);

    public IgnoreIssuesFilter(PatternMatcher patternMatcher) {
        this.patternMatcher = patternMatcher;
    }

    public boolean accept(FilterableIssue issue, IssueFilterChain chain) {
        if (this.hasMatchFor(issue)) {
            return false;
        }
        return chain.accept(issue);
    }

    private boolean hasMatchFor(FilterableIssue issue) {
        IssuePattern pattern = this.patternMatcher.getMatchingPattern(issue.componentKey(), issue.ruleKey(), issue.line());
        if (pattern != null) {
            IgnoreIssuesFilter.logExclusion(issue, pattern);
            return true;
        }
        return false;
    }

    private static void logExclusion(FilterableIssue issue, IssuePattern pattern) {
        LOG.debug("Issue {} ignored by exclusion pattern {}", (Object)issue, (Object)pattern);
    }
}

