/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.scanner.issue.ignore;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.annotation.CheckForNull;
import javax.annotation.concurrent.ThreadSafe;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.sonar.api.batch.fs.InputComponent;
import org.sonar.api.batch.fs.InputFile;
import org.sonar.api.scan.issue.filter.FilterableIssue;
import org.sonar.api.scan.issue.filter.IssueFilter;
import org.sonar.api.scan.issue.filter.IssueFilterChain;
import org.sonar.scanner.issue.ignore.pattern.IssueInclusionPatternInitializer;
import org.sonar.scanner.issue.ignore.pattern.IssuePattern;
import org.sonar.scanner.scan.filesystem.InputComponentStore;

@ThreadSafe
public class EnforceIssuesFilter
implements IssueFilter {
    private static final Logger LOG = LoggerFactory.getLogger(EnforceIssuesFilter.class);
    private final List<IssuePattern> multicriteriaPatterns;
    private final InputComponentStore componentStore;

    public EnforceIssuesFilter(IssueInclusionPatternInitializer patternInitializer, InputComponentStore componentStore) {
        this.multicriteriaPatterns = Collections.unmodifiableList(new ArrayList<IssuePattern>(patternInitializer.getMulticriteriaPatterns()));
        this.componentStore = componentStore;
    }

    public boolean accept(FilterableIssue issue, IssueFilterChain chain) {
        boolean atLeastOneRuleMatched = false;
        boolean atLeastOnePatternFullyMatched = false;
        IssuePattern matchingPattern = null;
        for (IssuePattern pattern : this.multicriteriaPatterns) {
            if (!pattern.getRulePattern().match(issue.ruleKey().toString())) continue;
            atLeastOneRuleMatched = true;
            String relativePath = this.getRelativePath(issue.componentKey());
            if (relativePath == null || !pattern.getResourcePattern().match(relativePath)) continue;
            atLeastOnePatternFullyMatched = true;
            matchingPattern = pattern;
        }
        if (atLeastOneRuleMatched) {
            if (atLeastOnePatternFullyMatched) {
                LOG.debug("Issue {} enforced by pattern {}", (Object)issue, matchingPattern);
            }
            return atLeastOnePatternFullyMatched;
        }
        return chain.accept(issue);
    }

    @CheckForNull
    private String getRelativePath(String componentKey) {
        InputComponent component = this.componentStore.getByKey(componentKey);
        if (component == null || !component.isFile()) {
            return null;
        }
        InputFile inputPath = (InputFile)component;
        return inputPath.relativePath();
    }
}

