/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.scanner.issue;

import java.util.Date;
import javax.annotation.concurrent.ThreadSafe;
import org.apache.commons.lang.builder.ToStringBuilder;
import org.apache.commons.lang.builder.ToStringStyle;
import org.sonar.api.batch.fs.InputModule;
import org.sonar.api.batch.fs.internal.DefaultInputModule;
import org.sonar.api.rule.RuleKey;
import org.sonar.api.scan.issue.filter.FilterableIssue;
import org.sonar.scanner.ProjectAnalysisInfo;
import org.sonar.scanner.protocol.output.ScannerReport;

@ThreadSafe
public class DefaultFilterableIssue
implements FilterableIssue {
    private final ScannerReport.Issue rawIssue;
    private final ProjectAnalysisInfo projectAnalysisInfo;
    private final String componentKey;
    private DefaultInputModule module;

    public DefaultFilterableIssue(InputModule module, ProjectAnalysisInfo projectAnalysisInfo, ScannerReport.Issue rawIssue, String componentKey) {
        this.module = (DefaultInputModule)module;
        this.projectAnalysisInfo = projectAnalysisInfo;
        this.rawIssue = rawIssue;
        this.componentKey = componentKey;
    }

    public String componentKey() {
        return this.componentKey;
    }

    public RuleKey ruleKey() {
        return RuleKey.of((String)this.rawIssue.getRuleRepository(), (String)this.rawIssue.getRuleKey());
    }

    public String severity() {
        return this.rawIssue.getSeverity().name();
    }

    public String message() {
        return this.rawIssue.getMsg();
    }

    public Integer line() {
        return this.rawIssue.hasTextRange() ? Integer.valueOf(this.rawIssue.getTextRange().getStartLine()) : null;
    }

    public Double gap() {
        return this.rawIssue.getGap() != 0.0 ? Double.valueOf(this.rawIssue.getGap()) : null;
    }

    public Double effortToFix() {
        return this.gap();
    }

    public Date creationDate() {
        return this.projectAnalysisInfo.analysisDate();
    }

    public String projectKey() {
        return this.module.key();
    }

    public String toString() {
        return ToStringBuilder.reflectionToString((Object)this, (ToStringStyle)ToStringStyle.SHORT_PREFIX_STYLE);
    }
}

