/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.scanner.bootstrap;

import org.apache.commons.lang.StringUtils;
import org.picocontainer.injectors.ProviderAdapter;
import org.sonar.api.batch.ScannerSide;
import org.sonar.batch.bootstrapper.EnvironmentInformation;
import org.sonar.scanner.bootstrap.GlobalAnalysisMode;
import org.sonar.scanner.bootstrap.GlobalProperties;
import org.sonar.scanner.bootstrap.ScannerWsClient;
import org.sonarqube.ws.client.HttpConnector;
import org.sonarqube.ws.client.WsClientFactories;
import org.sonarqube.ws.client.WsConnector;

@ScannerSide
public class ScannerWsClientProvider
extends ProviderAdapter {
    static final int CONNECT_TIMEOUT_MS = 5000;
    static final String READ_TIMEOUT_SEC_PROPERTY = "sonar.ws.timeout";
    static final int DEFAULT_READ_TIMEOUT_SEC = 60;
    private ScannerWsClient wsClient;

    public synchronized ScannerWsClient provide(GlobalProperties settings, EnvironmentInformation env, GlobalAnalysisMode globalMode) {
        if (this.wsClient == null) {
            String url = StringUtils.defaultIfBlank((String)settings.property("sonar.host.url"), (String)"http://localhost:9000");
            HttpConnector.Builder connectorBuilder = HttpConnector.newBuilder();
            String timeoutSec = StringUtils.defaultIfBlank((String)settings.property(READ_TIMEOUT_SEC_PROPERTY), (String)String.valueOf(60));
            String login = StringUtils.defaultIfBlank((String)settings.property("sonar.login"), null);
            connectorBuilder.readTimeoutMilliseconds(Integer.parseInt(timeoutSec) * 1000).connectTimeoutMilliseconds(5000).userAgent(env.toString()).url(url).credentials(login, settings.property("sonar.password"));
            String proxyUser = System.getProperty("http.proxyUser", "");
            if (!proxyUser.isEmpty()) {
                connectorBuilder.proxyCredentials(proxyUser, System.getProperty("http.proxyPassword"));
            }
            this.wsClient = new ScannerWsClient(WsClientFactories.getDefault().newClient((WsConnector)connectorBuilder.build()), login != null, globalMode);
        }
        return this.wsClient;
    }
}

