/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.scanner.bootstrap;

import java.lang.annotation.Annotation;
import java.lang.reflect.Array;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import org.apache.commons.lang.ClassUtils;
import org.sonar.api.batch.CheckProject;
import org.sonar.api.batch.DependedUpon;
import org.sonar.api.batch.DependsUpon;
import org.sonar.api.batch.Phase;
import org.sonar.api.batch.PostJob;
import org.sonar.api.batch.fs.internal.DefaultInputModule;
import org.sonar.api.batch.postjob.PostJobContext;
import org.sonar.api.batch.sensor.Sensor;
import org.sonar.api.batch.sensor.SensorContext;
import org.sonar.api.resources.Project;
import org.sonar.api.utils.AnnotationUtils;
import org.sonar.api.utils.dag.DirectAcyclicGraph;
import org.sonar.core.platform.ComponentContainer;
import org.sonar.scanner.bootstrap.ExtensionMatcher;
import org.sonar.scanner.postjob.PostJobOptimizer;
import org.sonar.scanner.postjob.PostJobWrapper;
import org.sonar.scanner.sensor.DefaultSensorContext;
import org.sonar.scanner.sensor.SensorOptimizer;
import org.sonar.scanner.sensor.SensorWrapper;

public class ScannerExtensionDictionnary {
    private final ComponentContainer componentContainer;
    private final SensorContext sensorContext;
    private final SensorOptimizer sensorOptimizer;
    private final PostJobContext postJobContext;
    private final PostJobOptimizer postJobOptimizer;

    public ScannerExtensionDictionnary(ComponentContainer componentContainer, DefaultSensorContext sensorContext, SensorOptimizer sensorOptimizer, PostJobContext postJobContext, PostJobOptimizer postJobOptimizer) {
        this.componentContainer = componentContainer;
        this.sensorContext = sensorContext;
        this.sensorOptimizer = sensorOptimizer;
        this.postJobContext = postJobContext;
        this.postJobOptimizer = postJobOptimizer;
    }

    public <T> Collection<T> select(Class<T> type, @Nullable DefaultInputModule module, boolean sort, @Nullable ExtensionMatcher matcher) {
        List<T> result = this.getFilteredExtensions(type, module, matcher);
        if (sort) {
            return this.sort(result);
        }
        return result;
    }

    public Collection<org.sonar.api.batch.Sensor> selectSensors(@Nullable DefaultInputModule module, boolean global) {
        List<org.sonar.api.batch.Sensor> result = this.getFilteredExtensions(org.sonar.api.batch.Sensor.class, module, null);
        Iterator<org.sonar.api.batch.Sensor> iterator = result.iterator();
        while (iterator.hasNext()) {
            org.sonar.api.batch.Sensor sensor = iterator.next();
            if (sensor instanceof SensorWrapper) {
                if (global == ((SensorWrapper)sensor).isGlobal()) continue;
                iterator.remove();
                continue;
            }
            if (!global) continue;
            iterator.remove();
        }
        return this.sort(result);
    }

    private static Phase.Name evaluatePhase(Object extension) {
        Object extensionToEvaluate = extension instanceof SensorWrapper ? ((SensorWrapper)extension).wrappedSensor() : (extension instanceof PostJobWrapper ? ((PostJobWrapper)extension).wrappedPostJob() : extension);
        Phase phaseAnnotation = (Phase)AnnotationUtils.getAnnotation((Object)extensionToEvaluate, Phase.class);
        if (phaseAnnotation != null) {
            return phaseAnnotation.name();
        }
        return Phase.Name.DEFAULT;
    }

    /*
     * WARNING - void declaration
     */
    private <T> List<T> getFilteredExtensions(Class<T> type, @Nullable DefaultInputModule module, @Nullable ExtensionMatcher matcher) {
        ArrayList<void> result = new ArrayList<void>();
        ArrayList<Object> candidates = new ArrayList<Object>();
        candidates.addAll(this.getExtensions(type));
        if (org.sonar.api.batch.Sensor.class.equals(type)) {
            candidates.addAll(this.getExtensions(Sensor.class));
        }
        if (PostJob.class.equals(type)) {
            candidates.addAll(this.getExtensions(org.sonar.api.batch.postjob.PostJob.class));
        }
        for (Object e : candidates) {
            void var7_7;
            void var7_10;
            if (org.sonar.api.batch.Sensor.class.equals(type) && e instanceof Sensor) {
                SensorWrapper sensorWrapper = new SensorWrapper((Sensor)e, this.sensorContext, this.sensorOptimizer);
            }
            if (PostJob.class.equals(type) && var7_10 instanceof org.sonar.api.batch.postjob.PostJob) {
                PostJobWrapper postJobWrapper = new PostJobWrapper((org.sonar.api.batch.postjob.PostJob)var7_10, this.postJobContext, this.postJobOptimizer);
            }
            if (!ScannerExtensionDictionnary.shouldKeep(type, var7_7, module, matcher)) continue;
            result.add(var7_7);
        }
        return result;
    }

    protected <T> List<T> getExtensions(Class<T> type) {
        ArrayList extensions = new ArrayList();
        ScannerExtensionDictionnary.completeBatchExtensions(this.componentContainer, extensions, type);
        return extensions;
    }

    private static <T> void completeBatchExtensions(ComponentContainer container, List<T> extensions, Class<T> type) {
        extensions.addAll(container.getComponentsByType(type));
        ComponentContainer parentContainer = container.getParent();
        if (parentContainer != null) {
            ScannerExtensionDictionnary.completeBatchExtensions(parentContainer, extensions, type);
        }
    }

    public <T> Collection<T> sort(Collection<T> extensions) {
        DirectAcyclicGraph dag = new DirectAcyclicGraph(new Object[0]);
        for (T extension : extensions) {
            dag.add(extension, new Object[0]);
            for (Object dependency : this.getDependencies(extension)) {
                dag.add(extension, new Object[]{dependency});
            }
            for (Object generates : this.getDependents(extension)) {
                dag.add(generates, new Object[]{extension});
            }
            ScannerExtensionDictionnary.completePhaseDependencies(dag, extension);
        }
        List sortedList = dag.sort();
        return sortedList.stream().filter(extensions::contains).collect(Collectors.toList());
    }

    private <T> List<Object> getDependencies(T extension) {
        ArrayList<Object> result = new ArrayList<Object>();
        result.addAll(this.evaluateAnnotatedClasses(extension, DependsUpon.class));
        return result;
    }

    public <T> List<Object> getDependents(T extension) {
        ArrayList<Object> result = new ArrayList<Object>();
        result.addAll(this.evaluateAnnotatedClasses(extension, DependedUpon.class));
        return result;
    }

    private static void completePhaseDependencies(DirectAcyclicGraph dag, Object extension) {
        Phase.Name phase = ScannerExtensionDictionnary.evaluatePhase(extension);
        dag.add(extension, new Object[]{phase});
        for (Phase.Name name : Phase.Name.values()) {
            if (phase.compareTo((Enum)name) < 0) {
                dag.add((Object)name, new Object[]{extension});
                continue;
            }
            if (phase.compareTo((Enum)name) <= 0) continue;
            dag.add(extension, new Object[]{name});
        }
    }

    protected List<Object> evaluateAnnotatedClasses(Object extension, Class<? extends Annotation> annotation) {
        ArrayList<Object> results = new ArrayList<Object>();
        for (Class<?> aClass = extension.getClass(); aClass != null; aClass = aClass.getSuperclass()) {
            ScannerExtensionDictionnary.evaluateClass(aClass, annotation, results);
            for (Method method : aClass.getDeclaredMethods()) {
                if (method.getAnnotation(annotation) == null) continue;
                ScannerExtensionDictionnary.checkAnnotatedMethod(method);
                this.evaluateMethod(extension, method, results);
            }
        }
        return results;
    }

    private static void evaluateClass(Class<?> extensionClass, Class<? extends Annotation> annotationClass, List<Object> results) {
        Class<?>[] interfaces;
        Annotation annotation = extensionClass.getAnnotation(annotationClass);
        if (annotation != null) {
            if (annotation.annotationType().isAssignableFrom(DependsUpon.class)) {
                results.addAll(Arrays.asList(((DependsUpon)annotation).value()));
            } else if (annotation.annotationType().isAssignableFrom(DependedUpon.class)) {
                results.addAll(Arrays.asList(((DependedUpon)annotation).value()));
            }
        }
        for (Class<?> anInterface : interfaces = extensionClass.getInterfaces()) {
            ScannerExtensionDictionnary.evaluateClass(anInterface, annotationClass, results);
        }
    }

    private void evaluateMethod(Object extension, Method method, List<Object> results) {
        try {
            Object result = method.invoke(extension, new Object[0]);
            if (result != null) {
                if (result instanceof Class) {
                    results.addAll(this.componentContainer.getComponentsByType((Class)result));
                } else if (result instanceof Collection) {
                    results.addAll((Collection)result);
                } else if (result.getClass().isArray()) {
                    for (int i = 0; i < Array.getLength(result); ++i) {
                        results.add(Array.get(result, i));
                    }
                } else {
                    results.add(result);
                }
            }
        }
        catch (Exception e) {
            throw new IllegalStateException("Can not invoke method " + method, e);
        }
    }

    private static void checkAnnotatedMethod(Method method) {
        if (!Modifier.isPublic(method.getModifiers())) {
            throw new IllegalStateException("Annotated method must be public:" + method);
        }
        if (method.getParameterTypes().length > 0) {
            throw new IllegalStateException("Annotated method must not have parameters:" + method);
        }
    }

    private static boolean shouldKeep(Class<?> type, Object extension, @Nullable DefaultInputModule module, @Nullable ExtensionMatcher matcher) {
        boolean keep;
        boolean bl = keep = (ClassUtils.isAssignable(extension.getClass(), type) || org.sonar.api.batch.Sensor.class.equals(type) && ClassUtils.isAssignable(extension.getClass(), Sensor.class)) && (matcher == null || matcher.accept(extension));
        if (keep && module != null && ClassUtils.isAssignable(extension.getClass(), CheckProject.class)) {
            keep = ((CheckProject)extension).shouldExecuteOnProject(new Project(module));
        }
        return keep;
    }
}

