/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.scanner.bootstrap;

import java.util.Arrays;
import javax.annotation.concurrent.Immutable;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.sonar.scanner.bootstrap.GlobalProperties;

@Immutable
public class GlobalAnalysisMode {
    public static final String MEDIUM_TEST_ENABLED = "sonar.mediumTest.enabled";
    private static final Logger LOG = LoggerFactory.getLogger(GlobalAnalysisMode.class);
    private static final String[] VALID_MODES = new String[]{"preview", "publish", "issues"};
    protected boolean preview;
    protected boolean issues;
    protected boolean mediumTestMode;

    public GlobalAnalysisMode(GlobalProperties props) {
        String mode = props.property("sonar.analysis.mode");
        GlobalAnalysisMode.validate(mode);
        this.issues = "issues".equals(mode) || "preview".equals(mode);
        this.mediumTestMode = "true".equals(props.property(MEDIUM_TEST_ENABLED));
        if (this.preview) {
            LOG.info("Preview mode");
            LOG.warn("The use of the preview mode (sonar.analysis.mode=preview) is deprecated. This mode will be dropped in the future.");
        } else if (this.issues) {
            LOG.info("Issues mode");
            LOG.warn("The use of the issues mode (sonar.analysis.mode=issues) is deprecated. This mode will be dropped in the future.");
        } else {
            LOG.info("Publish mode");
        }
        if (this.mediumTestMode) {
            LOG.info("Medium test mode");
        }
    }

    public boolean isPreview() {
        return this.preview;
    }

    public boolean isIssues() {
        return this.issues;
    }

    public boolean isPublish() {
        return !this.preview && !this.issues;
    }

    public boolean isMediumTest() {
        return this.mediumTestMode;
    }

    protected static void validate(String mode) {
        if (StringUtils.isEmpty((String)mode)) {
            return;
        }
        if (!Arrays.asList(VALID_MODES).contains(mode)) {
            throw new IllegalStateException("Invalid analysis mode: " + mode + ".");
        }
    }
}

