/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.scanner.analysis;

import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import org.picocontainer.ComponentLifecycle;
import org.picocontainer.PicoContainer;
import org.picocontainer.injectors.ProviderAdapter;
import org.sonar.api.batch.fs.internal.InputModuleHierarchy;
import org.sonar.api.utils.TempFolder;
import org.sonar.api.utils.internal.DefaultTempFolder;

public class AnalysisTempFolderProvider
extends ProviderAdapter
implements ComponentLifecycle<TempFolder> {
    static final String TMP_NAME = ".sonartmp";
    private DefaultTempFolder projectTempFolder;
    private boolean started = false;

    public TempFolder provide(InputModuleHierarchy moduleHierarchy) {
        if (this.projectTempFolder == null) {
            Path workingDir = moduleHierarchy.root().getWorkDir();
            Path tempDir = workingDir.normalize().resolve(TMP_NAME);
            try {
                Files.deleteIfExists(tempDir);
                Files.createDirectories(tempDir, new FileAttribute[0]);
            }
            catch (IOException e) {
                throw new IllegalStateException("Unable to create root temp directory " + tempDir, e);
            }
            this.projectTempFolder = new DefaultTempFolder(tempDir.toFile(), true);
        }
        return this.projectTempFolder;
    }

    public void start(PicoContainer container) {
        this.started = true;
    }

    public void stop(PicoContainer container) {
        if (this.projectTempFolder != null) {
            this.projectTempFolder.stop();
        }
    }

    public void dispose(PicoContainer container) {
    }

    public boolean componentHasLifecycle() {
        return true;
    }

    public boolean isStarted() {
        return this.started;
    }
}

