/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.batch.bootstrapper;

import ch.qos.logback.classic.Level;
import ch.qos.logback.classic.pattern.ExtendedThrowableProxyConverter;
import ch.qos.logback.classic.spi.ILoggingEvent;
import ch.qos.logback.core.UnsynchronizedAppenderBase;
import org.sonar.batch.bootstrapper.LogOutput;

public class LogCallbackAppender
extends UnsynchronizedAppenderBase<ILoggingEvent> {
    protected LogOutput target;

    public LogCallbackAppender(LogOutput target) {
        this.setTarget(target);
    }

    public void setTarget(LogOutput target) {
        this.target = target;
    }

    protected void append(ILoggingEvent event) {
        if (event.getThrowableProxy() == null) {
            this.target.log(event.getFormattedMessage(), LogCallbackAppender.translate(event.getLevel()));
        } else {
            ExtendedThrowableProxyConverter throwableConverter = new ExtendedThrowableProxyConverter();
            throwableConverter.start();
            this.target.log(event.getFormattedMessage() + "\n" + throwableConverter.convert(event), LogCallbackAppender.translate(event.getLevel()));
            throwableConverter.stop();
        }
    }

    private static LogOutput.Level translate(Level level) {
        switch (level.toInt()) {
            case 40000: {
                return LogOutput.Level.ERROR;
            }
            case 30000: {
                return LogOutput.Level.WARN;
            }
            case 20000: {
                return LogOutput.Level.INFO;
            }
            case 5000: {
                return LogOutput.Level.TRACE;
            }
        }
        return LogOutput.Level.DEBUG;
    }
}

