/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.api.server.rule;

import java.util.Collection;
import java.util.Locale;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import org.sonar.api.internal.apachecommons.lang.StringUtils;

public class RuleTagFormat {
    private static final String ERROR_MESSAGE_SUFFIX = "Rule tags accept only the characters: a-z, 0-9, '+', '-', '#', '.'";
    private static final String VALID_CHARACTERS_REGEX = "^[a-z0-9\\+#\\-\\.]+$";

    private RuleTagFormat() {
    }

    public static boolean isValid(String tag) {
        return StringUtils.isNotBlank(tag) && tag.matches(VALID_CHARACTERS_REGEX);
    }

    public static String validate(String tag) {
        if (!RuleTagFormat.isValid(tag)) {
            throw new IllegalArgumentException(String.format("Tag '%s' is invalid. %s", tag, ERROR_MESSAGE_SUFFIX));
        }
        return tag;
    }

    public static Set<String> validate(Collection<String> tags) {
        Set<String> sanitizedTags = tags.stream().filter(Objects::nonNull).filter(tag -> !tag.isEmpty()).map(tag -> tag.toLowerCase(Locale.ENGLISH)).collect(Collectors.toSet());
        Set invalidTags = sanitizedTags.stream().filter(tag -> !RuleTagFormat.isValid(tag)).collect(Collectors.toSet());
        if (invalidTags.isEmpty()) {
            return sanitizedTags;
        }
        throw new IllegalArgumentException(String.format("Tags '%s' are invalid. %s", String.join((CharSequence)", ", invalidTags), ERROR_MESSAGE_SUFFIX));
    }
}

