/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.api.batch.fs.internal.charhandler;

import org.sonar.api.batch.fs.internal.charhandler.CharHandler;
import org.sonar.api.batch.fs.internal.charhandler.IntArrayList;

public class LineOffsetCounter
extends CharHandler {
    private long currentOriginalLineStartOffset = 0L;
    private long currentOriginalLineEndOffset = 0L;
    private final IntArrayList originalLineStartOffsets = new IntArrayList();
    private final IntArrayList originalLineEndOffsets = new IntArrayList();
    private long lastValidOffset = 0L;

    public LineOffsetCounter() {
        this.originalLineStartOffsets.add(0);
    }

    @Override
    public void handleAll(char c) {
        ++this.currentOriginalLineStartOffset;
    }

    @Override
    public void handleIgnoreEoL(char c) {
        ++this.currentOriginalLineEndOffset;
    }

    @Override
    public void newLine() {
        if (this.currentOriginalLineStartOffset > Integer.MAX_VALUE) {
            throw new IllegalStateException("File is too big: " + this.currentOriginalLineStartOffset);
        }
        this.originalLineStartOffsets.add((int)this.currentOriginalLineStartOffset);
        this.originalLineEndOffsets.add((int)this.currentOriginalLineEndOffset);
        this.currentOriginalLineEndOffset = this.currentOriginalLineStartOffset;
    }

    @Override
    public void eof() {
        this.originalLineEndOffsets.add((int)this.currentOriginalLineEndOffset);
        this.lastValidOffset = this.currentOriginalLineStartOffset;
    }

    public int[] getOriginalLineStartOffsets() {
        return this.originalLineStartOffsets.trimAndGet();
    }

    public int[] getOriginalLineEndOffsets() {
        return this.originalLineEndOffsets.trimAndGet();
    }

    public int getLastValidOffset() {
        if (this.lastValidOffset > Integer.MAX_VALUE) {
            throw new IllegalStateException("File is too big: " + this.lastValidOffset);
        }
        return (int)this.lastValidOffset;
    }
}

