/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.api.batch.fs.internal;

import java.io.File;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import javax.annotation.CheckForNull;
import javax.annotation.concurrent.Immutable;
import org.sonar.api.batch.bootstrap.ProjectDefinition;
import org.sonar.api.batch.fs.InputModule;
import org.sonar.api.batch.fs.internal.AbstractProjectOrModule;
import org.sonar.api.config.internal.MultivalueProperty;
import org.sonar.api.scan.filesystem.PathResolver;

@Immutable
public class DefaultInputModule
extends AbstractProjectOrModule
implements InputModule {
    private final List<Path> sourceDirsOrFiles;
    private final List<Path> testDirsOrFiles;

    public DefaultInputModule(ProjectDefinition definition) {
        this(definition, 0);
    }

    public DefaultInputModule(ProjectDefinition definition, int scannerComponentId) {
        super(definition, scannerComponentId);
        this.sourceDirsOrFiles = this.initSources(definition, "sonar.sources");
        this.testDirsOrFiles = this.initSources(definition, "sonar.tests");
    }

    @CheckForNull
    private List<Path> initSources(ProjectDefinition module, String propertyKey) {
        if (!module.properties().containsKey(propertyKey)) {
            return null;
        }
        ArrayList<Path> result = new ArrayList<Path>();
        PathResolver pathResolver = new PathResolver();
        String srcPropValue = module.properties().get(propertyKey);
        if (srcPropValue != null) {
            for (String sourcePath : MultivalueProperty.parseAsCsv(propertyKey, srcPropValue)) {
                File dirOrFile = pathResolver.relativeFile(this.getBaseDir().toFile(), sourcePath);
                if (!dirOrFile.exists()) continue;
                result.add(dirOrFile.toPath());
            }
        }
        return result;
    }

    public Optional<List<Path>> getSourceDirsOrFiles() {
        return Optional.ofNullable(this.sourceDirsOrFiles);
    }

    public Optional<List<Path>> getTestDirsOrFiles() {
        return Optional.ofNullable(this.testDirsOrFiles);
    }
}

