/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.api.config;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Properties;
import java.util.stream.Collectors;
import javax.annotation.CheckForNull;
import javax.annotation.Nullable;
import org.sonar.api.ce.ComputeEngineSide;
import org.sonar.api.config.Encryption;
import org.sonar.api.config.PropertyDefinition;
import org.sonar.api.config.PropertyDefinitions;
import org.sonar.api.internal.apachecommons.lang.ArrayUtils;
import org.sonar.api.internal.apachecommons.lang.StringUtils;
import org.sonar.api.internal.google.common.base.Splitter;
import org.sonar.api.scanner.ScannerSide;
import org.sonar.api.server.ServerSide;
import org.sonar.api.utils.DateUtils;
import org.sonarsource.api.sonarlint.SonarLintSide;

@ServerSide
@ComputeEngineSide
@ScannerSide
@SonarLintSide
@Deprecated
public abstract class Settings {
    private final PropertyDefinitions definitions;
    private final Encryption encryption;

    protected Settings(PropertyDefinitions definitions, Encryption encryption) {
        this.definitions = Objects.requireNonNull(definitions);
        this.encryption = Objects.requireNonNull(encryption);
    }

    protected abstract Optional<String> get(String var1);

    protected abstract void set(String var1, String var2);

    protected abstract void remove(String var1);

    public abstract Map<String, String> getProperties();

    public Encryption getEncryption() {
        return this.encryption;
    }

    public Optional<String> getRawString(String key) {
        return this.get(this.definitions.validKey(Objects.requireNonNull(key)));
    }

    public PropertyDefinitions getDefinitions() {
        return this.definitions;
    }

    public Optional<PropertyDefinition> getDefinition(String key) {
        return Optional.ofNullable(this.definitions.get(key));
    }

    public boolean hasKey(String key) {
        return this.getRawString(key).isPresent();
    }

    @CheckForNull
    public String getDefaultValue(String key) {
        return this.definitions.getDefaultValue(key);
    }

    public boolean hasDefaultValue(String key) {
        return StringUtils.isNotEmpty(this.getDefaultValue(key));
    }

    @CheckForNull
    public String getString(String key) {
        String effectiveKey = this.definitions.validKey(key);
        Optional<String> value = this.getRawString(effectiveKey);
        if (!value.isPresent()) {
            return this.getDefaultValue(effectiveKey);
        }
        if (this.encryption.isEncrypted(value.get())) {
            try {
                return this.encryption.decrypt(value.get());
            }
            catch (Exception e) {
                throw new IllegalStateException("Fail to decrypt the property " + effectiveKey + ". Please check your secret key.", e);
            }
        }
        return value.get();
    }

    public boolean getBoolean(String key) {
        String value = this.getString(key);
        return StringUtils.isNotEmpty(value) && Boolean.parseBoolean(value);
    }

    public int getInt(String key) {
        String value = this.getString(key);
        if (StringUtils.isNotEmpty(value)) {
            return Integer.parseInt(value);
        }
        return 0;
    }

    public long getLong(String key) {
        String value = this.getString(key);
        if (StringUtils.isNotEmpty(value)) {
            return Long.parseLong(value);
        }
        return 0L;
    }

    @CheckForNull
    public Date getDate(String key) {
        String value = this.getString(key);
        if (StringUtils.isNotEmpty(value)) {
            return DateUtils.parseDate(value);
        }
        return null;
    }

    @CheckForNull
    public Date getDateTime(String key) {
        String value = this.getString(key);
        if (StringUtils.isNotEmpty(value)) {
            return DateUtils.parseDateTime(value);
        }
        return null;
    }

    @CheckForNull
    public Float getFloat(String key) {
        String value = this.getString(key);
        if (StringUtils.isNotEmpty(value)) {
            try {
                return Float.valueOf(value);
            }
            catch (NumberFormatException e) {
                throw new IllegalStateException(String.format("The property '%s' is not a float value", key));
            }
        }
        return null;
    }

    @CheckForNull
    public Double getDouble(String key) {
        String value = this.getString(key);
        if (StringUtils.isNotEmpty(value)) {
            try {
                return Double.valueOf(value);
            }
            catch (NumberFormatException e) {
                throw new IllegalStateException(String.format("The property '%s' is not a double value", key));
            }
        }
        return null;
    }

    public String[] getStringArray(String key) {
        String effectiveKey = this.definitions.validKey(key);
        Optional<PropertyDefinition> def = this.getDefinition(effectiveKey);
        if (def.isPresent() && def.get().multiValues()) {
            String value = this.getString(key);
            if (value == null) {
                return ArrayUtils.EMPTY_STRING_ARRAY;
            }
            ArrayList<String> values = new ArrayList<String>();
            for (String v : Splitter.on(",").trimResults().split(value)) {
                values.add(v.replace("%2C", ","));
            }
            return values.toArray(new String[values.size()]);
        }
        return this.getStringArrayBySeparator(key, ",");
    }

    public String[] getStringLines(String key) {
        String value = this.getString(key);
        if (StringUtils.isEmpty(value)) {
            return new String[0];
        }
        return value.split("\r?\n|\r", -1);
    }

    public String[] getStringArrayBySeparator(String key, String separator) {
        String value = this.getString(key);
        if (value != null) {
            String[] strings = StringUtils.splitByWholeSeparator(value, separator);
            String[] result = new String[strings.length];
            for (int index = 0; index < strings.length; ++index) {
                result[index] = StringUtils.trim(strings[index]);
            }
            return result;
        }
        return ArrayUtils.EMPTY_STRING_ARRAY;
    }

    public Settings appendProperty(String key, @Nullable String value) {
        Optional<String> existingValue = this.getRawString(this.definitions.validKey(key));
        String newValue = !existingValue.isPresent() ? StringUtils.trim(value) : existingValue.get() + "," + StringUtils.trim(value);
        return this.setProperty(key, newValue);
    }

    public Settings setProperty(String key, @Nullable String[] values) {
        Objects.requireNonNull(key, "key can't be null");
        String effectiveKey = key.trim();
        Optional<PropertyDefinition> def = this.getDefinition(effectiveKey);
        if (!def.isPresent() || !def.get().multiValues()) {
            throw new IllegalStateException("Fail to set multiple values on a single value property " + key);
        }
        String text = null;
        if (values != null) {
            ArrayList<String> escaped = new ArrayList<String>();
            for (String value : values) {
                if (null != value) {
                    escaped.add(value.replace(",", "%2C"));
                    continue;
                }
                escaped.add("");
            }
            String escapedValue = escaped.stream().collect(Collectors.joining(","));
            text = StringUtils.trim(escapedValue);
        }
        return this.setProperty(key, text);
    }

    public Settings setProperty(String key, @Nullable String value) {
        String validKey = this.definitions.validKey(key);
        if (value == null) {
            this.removeProperty(validKey);
        } else {
            this.set(validKey, StringUtils.trim(value));
        }
        return this;
    }

    public Settings setProperty(String key, @Nullable Boolean value) {
        return this.setProperty(key, value == null ? null : String.valueOf(value));
    }

    public Settings setProperty(String key, @Nullable Integer value) {
        return this.setProperty(key, value == null ? null : String.valueOf(value));
    }

    public Settings setProperty(String key, @Nullable Long value) {
        return this.setProperty(key, value == null ? null : String.valueOf(value));
    }

    public Settings setProperty(String key, @Nullable Double value) {
        return this.setProperty(key, value == null ? null : String.valueOf(value));
    }

    public Settings setProperty(String key, @Nullable Float value) {
        return this.setProperty(key, value == null ? null : String.valueOf(value));
    }

    public Settings setProperty(String key, @Nullable Date date) {
        return this.setProperty(key, date, false);
    }

    public Settings addProperties(Map<String, String> props) {
        for (Map.Entry<String, String> entry : props.entrySet()) {
            this.setProperty(entry.getKey(), entry.getValue());
        }
        return this;
    }

    public Settings addProperties(Properties props) {
        for (Map.Entry<Object, Object> entry : props.entrySet()) {
            this.setProperty(entry.getKey().toString(), entry.getValue().toString());
        }
        return this;
    }

    public Settings setProperty(String key, @Nullable Date date, boolean includeTime) {
        if (date == null) {
            return this.removeProperty(key);
        }
        return this.setProperty(key, includeTime ? DateUtils.formatDateTime(date) : DateUtils.formatDate(date));
    }

    public Settings removeProperty(String key) {
        this.remove(key);
        return this;
    }

    public List<String> getKeysStartingWith(String prefix) {
        return this.getProperties().keySet().stream().filter(key -> StringUtils.startsWith(key, prefix)).collect(Collectors.toList());
    }
}

