/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.api.batch.fs.internal.charhandler;

import java.util.Arrays;

class IntArrayList {
    private static final int DEFAULT_CAPACITY = 10;
    private static final int[] DEFAULTCAPACITY_EMPTY_ELEMENTDATA = new int[0];
    private int[] elementData = DEFAULTCAPACITY_EMPTY_ELEMENTDATA;
    private int size;

    public int[] trimAndGet() {
        if (this.size < this.elementData.length) {
            this.elementData = Arrays.copyOf(this.elementData, this.size);
        }
        return this.elementData;
    }

    private void ensureCapacityInternal(int minCapacity) {
        int capacity = minCapacity;
        if (this.elementData == DEFAULTCAPACITY_EMPTY_ELEMENTDATA) {
            capacity = Math.max(10, minCapacity);
        }
        this.ensureExplicitCapacity(capacity);
    }

    private void ensureExplicitCapacity(int minCapacity) {
        if (minCapacity - this.elementData.length > 0) {
            this.grow(minCapacity);
        }
    }

    private void grow(int minCapacity) {
        int oldCapacity = this.elementData.length;
        int newCapacity = oldCapacity + (oldCapacity >> 1);
        if (newCapacity - minCapacity < 0) {
            newCapacity = minCapacity;
        }
        this.elementData = Arrays.copyOf(this.elementData, newCapacity);
    }

    public boolean add(int e) {
        this.ensureCapacityInternal(this.size + 1);
        this.elementData[this.size] = e;
        ++this.size;
        return true;
    }
}

