/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.api.batch.fs.internal;

import java.util.Arrays;
import javax.annotation.concurrent.Immutable;

@Immutable
public class Metadata {
    private final int lines;
    private final int nonBlankLines;
    private final String hash;
    private final int[] originalLineStartOffsets;
    private final int[] originalLineEndOffsets;
    private final int lastValidOffset;

    public Metadata(int lines, int nonBlankLines, String hash, int[] originalLineStartOffsets, int[] originalLineEndOffsets, int lastValidOffset) {
        this.lines = lines;
        this.nonBlankLines = nonBlankLines;
        this.hash = hash;
        this.originalLineStartOffsets = Arrays.copyOf(originalLineStartOffsets, originalLineStartOffsets.length);
        this.originalLineEndOffsets = Arrays.copyOf(originalLineEndOffsets, originalLineEndOffsets.length);
        this.lastValidOffset = lastValidOffset;
    }

    public int lines() {
        return this.lines;
    }

    public int nonBlankLines() {
        return this.nonBlankLines;
    }

    public String hash() {
        return this.hash;
    }

    public int[] originalLineStartOffsets() {
        return this.originalLineStartOffsets;
    }

    public int[] originalLineEndOffsets() {
        return this.originalLineEndOffsets;
    }

    public int lastValidOffset() {
        return this.lastValidOffset;
    }

    public boolean isEmpty() {
        return this.lastValidOffset == 0;
    }
}

