/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.api.batch.fs.internal.charhandler;

import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.CharacterCodingException;
import java.nio.charset.CharsetEncoder;
import java.nio.charset.CodingErrorAction;
import java.nio.charset.StandardCharsets;
import java.security.MessageDigest;
import javax.annotation.CheckForNull;
import org.sonar.api.batch.fs.internal.charhandler.CharHandler;
import org.sonar.api.internal.apachecommons.codec.binary.Hex;
import org.sonar.api.internal.apachecommons.codec.digest.DigestUtils;

public class FileHashComputer
extends CharHandler {
    private static final char LINE_FEED = '\n';
    private MessageDigest globalMd5Digest = DigestUtils.getMd5Digest();
    private StringBuilder sb = new StringBuilder();
    private final CharsetEncoder encoder = StandardCharsets.UTF_8.newEncoder().onMalformedInput(CodingErrorAction.REPLACE).onUnmappableCharacter(CodingErrorAction.REPLACE);
    private final String filePath;

    public FileHashComputer(String filePath) {
        this.filePath = filePath;
    }

    @Override
    public void handleIgnoreEoL(char c) {
        this.sb.append(c);
    }

    @Override
    public void newLine() {
        this.sb.append('\n');
        this.processBuffer();
        this.sb.setLength(0);
    }

    @Override
    public void eof() {
        if (this.sb.length() > 0) {
            this.processBuffer();
        }
    }

    private void processBuffer() {
        try {
            if (this.sb.length() > 0) {
                ByteBuffer encoded = this.encoder.encode(CharBuffer.wrap(this.sb));
                this.globalMd5Digest.update(encoded.array(), 0, encoded.limit());
            }
        }
        catch (CharacterCodingException e) {
            throw new IllegalStateException("Error encoding line hash in file: " + this.filePath, e);
        }
    }

    @CheckForNull
    public String getHash() {
        return Hex.encodeHexString(this.globalMd5Digest.digest());
    }
}

