/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.api.ce.measure;

import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import javax.annotation.CheckForNull;
import org.sonar.api.internal.google.common.collect.Multiset;
import org.sonar.api.internal.google.common.collect.TreeMultiset;
import org.sonar.api.utils.KeyValueFormat;

public class RangeDistributionBuilder {
    private Multiset<Number> distributionSet;
    private boolean isEmpty = true;
    private Number[] bottomLimits;
    private boolean isValid = true;

    public RangeDistributionBuilder() {
    }

    public RangeDistributionBuilder(Number[] bottomLimits) {
        this.init(bottomLimits);
    }

    public RangeDistributionBuilder add(Number value) {
        return this.add(value, 1);
    }

    public RangeDistributionBuilder add(Number value, int count) {
        if (RangeDistributionBuilder.greaterOrEqualsThan(value, this.bottomLimits[0])) {
            this.addValue(value, count);
            this.isEmpty = false;
        }
        return this;
    }

    public RangeDistributionBuilder add(String data) {
        Map<Double, Double> map = KeyValueFormat.parse(data, KeyValueFormat.newDoubleConverter(), KeyValueFormat.newDoubleConverter());
        if (this.bottomLimits == null) {
            Number[] limits = map.keySet().toArray(new Number[map.size()]);
            this.init(limits);
        } else if (!RangeDistributionBuilder.areSameLimits(this.bottomLimits, map.keySet())) {
            this.isValid = false;
        }
        if (this.isValid) {
            for (Map.Entry<Double, Double> entry : map.entrySet()) {
                this.addLimitCount(entry.getKey(), entry.getValue().intValue());
            }
        }
        return this;
    }

    private void init(Number[] bottomLimits) {
        this.bottomLimits = new Number[bottomLimits.length];
        System.arraycopy(bottomLimits, 0, this.bottomLimits, 0, this.bottomLimits.length);
        Arrays.sort(this.bottomLimits);
        this.changeDoublesToInts();
        this.distributionSet = TreeMultiset.create(NumberComparator.INSTANCE);
    }

    private void changeDoublesToInts() {
        for (Number bottomLimit : this.bottomLimits) {
            if (NumberComparator.INSTANCE.compare(bottomLimit.intValue(), bottomLimit.doubleValue()) == 0) continue;
            return;
        }
        for (int i = 0; i < this.bottomLimits.length; ++i) {
            this.bottomLimits[i] = this.bottomLimits[i].intValue();
        }
    }

    private static boolean areSameLimits(Number[] bottomLimits, Set<Double> limits) {
        if (limits.size() == bottomLimits.length) {
            for (Number l : bottomLimits) {
                if (limits.contains(l.doubleValue())) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    private RangeDistributionBuilder addLimitCount(Number limit, int count) {
        for (Number bottomLimit : this.bottomLimits) {
            if (NumberComparator.INSTANCE.compare(bottomLimit.doubleValue(), limit.doubleValue()) != 0) continue;
            this.addValue(limit, count);
            this.isEmpty = false;
            return this;
        }
        this.isValid = false;
        return this;
    }

    private void addValue(Number value, int count) {
        for (int i = this.bottomLimits.length - 1; i >= 0; --i) {
            if (!RangeDistributionBuilder.greaterOrEqualsThan(value, this.bottomLimits[i])) continue;
            this.distributionSet.add(this.bottomLimits[i], count);
            return;
        }
    }

    public boolean isEmpty() {
        return this.isEmpty;
    }

    @CheckForNull
    public String build() {
        if (this.isValid) {
            return KeyValueFormat.format(this.toMap());
        }
        return null;
    }

    private Map<Number, Integer> toMap() {
        if (this.bottomLimits == null || this.bottomLimits.length == 0) {
            return Collections.emptyMap();
        }
        TreeMap<Number, Integer> map = new TreeMap<Number, Integer>();
        for (Number value : this.bottomLimits) {
            map.put(value, this.distributionSet.count(value));
        }
        return map;
    }

    private static boolean greaterOrEqualsThan(Number n1, Number n2) {
        return NumberComparator.INSTANCE.compare(n1, n2) >= 0;
    }

    private static enum NumberComparator implements Comparator<Number>
    {
        INSTANCE;


        @Override
        public int compare(Number n1, Number n2) {
            return Double.compare(n1.doubleValue(), n2.doubleValue());
        }
    }
}

