/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.api.batch.sensor.issue.internal;

import java.util.Objects;
import javax.annotation.Nullable;
import org.apache.commons.lang.StringUtils;
import org.sonar.api.batch.fs.InputComponent;
import org.sonar.api.batch.fs.TextRange;
import org.sonar.api.batch.fs.internal.DefaultInputFile;
import org.sonar.api.batch.sensor.issue.IssueLocation;
import org.sonar.api.batch.sensor.issue.NewIssueLocation;
import org.sonar.api.utils.Preconditions;

public class DefaultIssueLocation
implements NewIssueLocation,
IssueLocation {
    private InputComponent component;
    private TextRange textRange;
    private String message;

    public DefaultIssueLocation on(InputComponent component) {
        Preconditions.checkArgument((component != null ? 1 : 0) != 0, (String)"Component can't be null");
        Preconditions.checkState((this.component == null ? 1 : 0) != 0, (String)"on() already called");
        this.component = component;
        return this;
    }

    public DefaultIssueLocation at(TextRange location) {
        Preconditions.checkState((this.component != null ? 1 : 0) != 0, (String)"at() should be called after on()");
        Preconditions.checkState((boolean)this.component.isFile(), (String)"at() should be called only for an InputFile.");
        DefaultInputFile file = (DefaultInputFile)this.component;
        file.validate(location);
        this.textRange = location;
        return this;
    }

    public DefaultIssueLocation message(String message) {
        Objects.requireNonNull(message, "Message can't be null");
        if (message.contains("\u0000")) {
            throw new IllegalArgumentException(DefaultIssueLocation.unsupportedCharacterError(message, this.component));
        }
        this.message = StringUtils.abbreviate((String)StringUtils.trim((String)message), (int)4000);
        return this;
    }

    private static String unsupportedCharacterError(String message, @Nullable InputComponent component) {
        String error = "Character \\u0000 is not supported in issue message '" + message + "'";
        if (component != null) {
            error = error + ", on component: " + component.toString();
        }
        return error;
    }

    public InputComponent inputComponent() {
        return this.component;
    }

    public TextRange textRange() {
        return this.textRange;
    }

    public String message() {
        return this.message;
    }
}

