/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.api.batch.rule.internal;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.concurrent.Immutable;
import org.sonar.api.batch.rule.ActiveRule;
import org.sonar.api.batch.rule.internal.NewActiveRule;
import org.sonar.api.rule.RuleKey;

@Immutable
public class DefaultActiveRule
implements ActiveRule {
    private final RuleKey ruleKey;
    private final String severity;
    private final String internalKey;
    private final String language;
    private final String templateRuleKey;
    private final Map<String, String> params;
    private final long createdAt;
    private final long updatedAt;
    private final String qProfileKey;

    public DefaultActiveRule(NewActiveRule newActiveRule) {
        this.severity = newActiveRule.severity;
        this.internalKey = newActiveRule.internalKey;
        this.templateRuleKey = newActiveRule.templateRuleKey;
        this.ruleKey = newActiveRule.ruleKey;
        this.params = Collections.unmodifiableMap(new HashMap<String, String>(newActiveRule.params));
        this.language = newActiveRule.language;
        this.createdAt = newActiveRule.createdAt;
        this.updatedAt = newActiveRule.updatedAt;
        this.qProfileKey = newActiveRule.qProfileKey;
    }

    public RuleKey ruleKey() {
        return this.ruleKey;
    }

    public String severity() {
        return this.severity;
    }

    public String language() {
        return this.language;
    }

    public String param(String key) {
        return this.params.get(key);
    }

    public Map<String, String> params() {
        return this.params;
    }

    public String internalKey() {
        return this.internalKey;
    }

    public String templateRuleKey() {
        return this.templateRuleKey;
    }

    public long createdAt() {
        return this.createdAt;
    }

    public long updatedAt() {
        return this.updatedAt;
    }

    public String qpKey() {
        return this.qProfileKey;
    }
}

