/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.api.batch.fs.internal;

import java.nio.file.Path;
import javax.annotation.concurrent.ThreadSafe;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.lang.StringUtils;
import org.sonar.api.utils.PathUtils;
import org.sonar.api.utils.WildcardPattern;
import org.sonar.api.utils.log.Logger;
import org.sonar.api.utils.log.Loggers;

@ThreadSafe
public abstract class PathPattern {
    private static final Logger LOG = Loggers.get(PathPattern.class);
    @Deprecated
    private static final String ABSOLUTE_PATH_PATTERN_PREFIX = "file:";
    final WildcardPattern pattern;

    PathPattern(String pattern) {
        this.pattern = WildcardPattern.create((String)pattern);
    }

    public abstract boolean match(Path var1, Path var2);

    public abstract boolean match(Path var1, Path var2, boolean var3);

    public static PathPattern create(String s) {
        String trimmed = StringUtils.trim((String)s);
        if (StringUtils.startsWithIgnoreCase((String)trimmed, (String)ABSOLUTE_PATH_PATTERN_PREFIX)) {
            LOG.warn("Using absolute path pattern is deprecated. Please use relative path instead of '" + trimmed + "'");
            return new AbsolutePathPattern(StringUtils.substring((String)trimmed, (int)ABSOLUTE_PATH_PATTERN_PREFIX.length()));
        }
        return new RelativePathPattern(trimmed);
    }

    public static PathPattern[] create(String[] s) {
        PathPattern[] result = new PathPattern[s.length];
        for (int i = 0; i < s.length; ++i) {
            result[i] = PathPattern.create(s[i]);
        }
        return result;
    }

    static String sanitizeExtension(String suffix) {
        return StringUtils.lowerCase((String)StringUtils.removeStart((String)suffix, (String)"."));
    }

    private static class RelativePathPattern
    extends PathPattern {
        private RelativePathPattern(String pattern) {
            super(pattern);
        }

        @Override
        public boolean match(Path absolutePath, Path relativePath) {
            return this.match(absolutePath, relativePath, true);
        }

        @Override
        public boolean match(Path absolutePath, Path relativePath, boolean caseSensitiveFileExtension) {
            String extension;
            String path = PathUtils.sanitize((String)relativePath.toString());
            if (!caseSensitiveFileExtension && StringUtils.isNotBlank((String)(extension = RelativePathPattern.sanitizeExtension(FilenameUtils.getExtension((String)path))))) {
                path = StringUtils.removeEndIgnoreCase((String)path, (String)extension);
                path = path + extension;
            }
            return path != null && this.pattern.match(path);
        }

        public String toString() {
            return this.pattern.toString();
        }
    }

    @Deprecated
    private static class AbsolutePathPattern
    extends PathPattern {
        private AbsolutePathPattern(String pattern) {
            super(pattern);
        }

        @Override
        public boolean match(Path absolutePath, Path relativePath) {
            return this.match(absolutePath, relativePath, true);
        }

        @Override
        public boolean match(Path absolutePath, Path relativePath, boolean caseSensitiveFileExtension) {
            String extension;
            String path = PathUtils.sanitize((String)absolutePath.toString());
            if (!caseSensitiveFileExtension && StringUtils.isNotBlank((String)(extension = AbsolutePathPattern.sanitizeExtension(FilenameUtils.getExtension((String)path))))) {
                path = StringUtils.removeEndIgnoreCase((String)path, (String)extension);
                path = path + extension;
            }
            return this.pattern.match(path);
        }

        public String toString() {
            return PathPattern.ABSOLUTE_PATH_PATTERN_PREFIX + this.pattern.toString();
        }
    }
}

