/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.duplications.block;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.sonar.duplications.block.Block;
import org.sonar.duplications.block.ByteArray;
import org.sonar.duplications.statement.Statement;

public class BlockChunker {
    private static final long PRIME_BASE = 31L;
    private final int blockSize;
    private final long power;

    public BlockChunker(int blockSize) {
        this.blockSize = blockSize;
        long pow = 1L;
        for (int i = 0; i < blockSize - 1; ++i) {
            pow *= 31L;
        }
        this.power = pow;
    }

    public List<Block> chunk(String resourceId, List<Statement> statements) {
        int last;
        ArrayList<Statement> filtered = new ArrayList<Statement>();
        int i = 0;
        while (i < statements.size()) {
            int j;
            Statement first = statements.get(i);
            for (j = i + 1; j < statements.size() && statements.get(j).getValue().equals(first.getValue()); ++j) {
            }
            filtered.add(statements.get(i));
            if (i < j - 1) {
                filtered.add(statements.get(j - 1));
            }
            i = j;
        }
        statements = filtered;
        if (statements.size() < this.blockSize) {
            return Collections.emptyList();
        }
        Statement[] statementsArr = statements.toArray(new Statement[statements.size()]);
        ArrayList<Block> blocks = new ArrayList<Block>(statementsArr.length - this.blockSize + 1);
        long hash = 0L;
        int first = 0;
        for (last = 0; last < this.blockSize - 1; ++last) {
            hash = hash * 31L + (long)statementsArr[last].getValue().hashCode();
        }
        Block.Builder blockBuilder = Block.builder().setResourceId(resourceId);
        while (last < statementsArr.length) {
            Statement firstStatement = statementsArr[first];
            Statement lastStatement = statementsArr[last];
            hash = hash * 31L + (long)lastStatement.getValue().hashCode();
            Block block = blockBuilder.setBlockHash(new ByteArray(hash)).setIndexInFile(first).setLines(firstStatement.getStartLine(), lastStatement.getEndLine()).build();
            blocks.add(block);
            hash -= this.power * (long)firstStatement.getValue().hashCode();
            ++last;
            ++first;
        }
        return blocks;
    }

    public int getBlockSize() {
        return this.blockSize;
    }
}

