/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.core.issue;

import com.google.common.base.Preconditions;
import com.google.common.collect.Maps;
import java.util.Map;
import javax.annotation.Nullable;
import org.sonar.api.batch.sensor.issue.NewIssueLocation;
import org.sonar.api.issue.Issuable;
import org.sonar.api.rule.RuleKey;
import org.sonar.core.issue.DefaultIssue;
import org.sonar.core.util.Uuids;

public class DefaultIssueBuilder
implements Issuable.IssueBuilder {
    private String componentKey;
    private String projectKey;
    private RuleKey ruleKey;
    private Integer line;
    private String message;
    private String severity;
    private Double effortToFix;
    private String reporter;
    private String assignee;
    private Map<String, String> attributes;

    public DefaultIssueBuilder componentKey(String componentKey) {
        this.componentKey = componentKey;
        return this;
    }

    public DefaultIssueBuilder projectKey(String projectKey) {
        this.projectKey = projectKey;
        return this;
    }

    @Override
    public DefaultIssueBuilder ruleKey(RuleKey ruleKey) {
        this.ruleKey = ruleKey;
        return this;
    }

    @Override
    public DefaultIssueBuilder line(@Nullable Integer line) {
        this.line = line;
        return this;
    }

    @Override
    public DefaultIssueBuilder message(@Nullable String s) {
        this.message = s;
        return this;
    }

    @Override
    public NewIssueLocation newLocation() {
        throw DefaultIssueBuilder.unsupported();
    }

    @Override
    public Issuable.IssueBuilder addLocation(NewIssueLocation secondaryLocation) {
        throw DefaultIssueBuilder.unsupported();
    }

    @Override
    public Issuable.IssueBuilder addFlow(Iterable<NewIssueLocation> flow) {
        throw DefaultIssueBuilder.unsupported();
    }

    @Override
    public Issuable.IssueBuilder at(NewIssueLocation location) {
        throw DefaultIssueBuilder.unsupported();
    }

    private static UnsupportedOperationException unsupported() {
        return new UnsupportedOperationException("Not supported for manual issues");
    }

    @Override
    public DefaultIssueBuilder severity(@Nullable String severity) {
        this.severity = severity;
        return this;
    }

    @Override
    public DefaultIssueBuilder effortToFix(@Nullable Double d) {
        this.effortToFix = d;
        return this;
    }

    @Override
    public DefaultIssueBuilder reporter(@Nullable String s) {
        this.reporter = s;
        return this;
    }

    public DefaultIssueBuilder assignee(@Nullable String s) {
        this.assignee = s;
        return this;
    }

    @Override
    public DefaultIssueBuilder attribute(String key, @Nullable String value) {
        if (this.attributes == null) {
            this.attributes = Maps.newLinkedHashMap();
        }
        this.attributes.put(key, value);
        return this;
    }

    @Override
    public DefaultIssue build() {
        Preconditions.checkNotNull((Object)this.projectKey, (Object)"Project key must be set");
        Preconditions.checkNotNull((Object)this.componentKey, (Object)"Component key must be set");
        Preconditions.checkNotNull((Object)this.ruleKey, (Object)"Rule key must be set");
        DefaultIssue issue = new DefaultIssue();
        String key = Uuids.create();
        issue.setKey(key);
        issue.setComponentKey(this.componentKey);
        issue.setProjectKey(this.projectKey);
        issue.setRuleKey(this.ruleKey);
        issue.setMessage(this.message);
        issue.setSeverity(this.severity);
        issue.setManualSeverity(false);
        issue.setEffortToFix(this.effortToFix);
        issue.setLine(this.line);
        issue.setReporter(this.reporter);
        issue.setAssignee(this.assignee);
        issue.setAttributes(this.attributes);
        issue.setResolution(null);
        issue.setStatus("OPEN");
        issue.setCloseDate(null);
        issue.setNew(true);
        issue.setBeingClosed(false);
        issue.setOnDisabledRule(false);
        return issue;
    }
}

