/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.api.server.ws.internal;

import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import javax.annotation.CheckForNull;
import javax.annotation.Nullable;
import org.sonar.api.internal.apachecommons.lang.StringUtils;
import org.sonar.api.internal.google.common.base.CharMatcher;
import org.sonar.api.internal.google.common.base.Splitter;
import org.sonar.api.internal.google.common.collect.Lists;
import org.sonar.api.server.ws.Request;
import org.sonar.api.server.ws.WebService;
import org.sonar.api.utils.log.Loggers;

public abstract class ValidatingRequest
extends Request {
    private WebService.Action action;

    public void setAction(WebService.Action action) {
        this.action = action;
    }

    public WebService.Action action() {
        return this.action;
    }

    @Override
    @CheckForNull
    public String param(String key) {
        return this.param(key, true);
    }

    @Override
    @CheckForNull
    public InputStream paramAsInputStream(String key) {
        return this.readInputStreamParam(key);
    }

    @CheckForNull
    private String param(String key, boolean validateValue) {
        String trimmedValue;
        WebService.Param definition = this.action.param(key);
        String value = this.readParamOrDefaultValue(key, definition);
        String string = trimmedValue = value == null ? value : CharMatcher.WHITESPACE.trimFrom(value);
        if (trimmedValue != null && validateValue) {
            ValidatingRequest.validate(trimmedValue, definition);
        }
        return trimmedValue;
    }

    @Override
    @CheckForNull
    public List<String> paramAsStrings(String key) {
        WebService.Param definition = this.action.param(key);
        String value = this.readParamOrDefaultValue(key, definition);
        if (value == null) {
            return null;
        }
        ArrayList<String> values = Lists.newArrayList(Splitter.on(',').omitEmptyStrings().trimResults().split(value));
        for (String s : values) {
            ValidatingRequest.validate(s, definition);
        }
        return values;
    }

    @Override
    @CheckForNull
    public <E extends Enum<E>> List<E> paramAsEnums(String key, Class<E> enumClass) {
        WebService.Param definition = this.action.param(key);
        String value = this.readParamOrDefaultValue(key, definition);
        if (value == null) {
            return null;
        }
        Iterable<String> values = Splitter.on(',').omitEmptyStrings().trimResults().split(value);
        ArrayList<E> result = new ArrayList<E>();
        for (String s : values) {
            ValidatingRequest.validate(s, definition);
            result.add(Enum.valueOf(enumClass, s));
        }
        return result;
    }

    @CheckForNull
    private String readParamOrDefaultValue(String key, @Nullable WebService.Param definition) {
        if (definition == null) {
            String message = String.format("BUG - parameter '%s' is undefined for action '%s'", key, this.action.key());
            Loggers.get(this.getClass()).error(message);
            throw new IllegalArgumentException(message);
        }
        String deprecatedKey = definition.deprecatedKey();
        String value = deprecatedKey != null ? StringUtils.defaultString(this.readParam(deprecatedKey), this.readParam(key)) : this.readParam(key);
        if ((value = StringUtils.defaultString(value, definition.defaultValue())) == null) {
            return null;
        }
        return value;
    }

    @CheckForNull
    protected abstract String readParam(String var1);

    @CheckForNull
    protected abstract InputStream readInputStreamParam(String var1);

    private static void validate(String value, WebService.Param definition) {
        Set<String> possibleValues = definition.possibleValues();
        if (possibleValues != null && !possibleValues.contains(value)) {
            throw new IllegalArgumentException(String.format("Value of parameter '%s' (%s) must be one of: %s", definition.key(), value, possibleValues));
        }
    }
}

