/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.api.server.ws;

import java.io.InputStream;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import javax.annotation.CheckForNull;
import org.sonar.api.internal.apachecommons.lang.StringUtils;
import org.sonar.api.internal.google.common.base.Splitter;
import org.sonar.api.internal.google.common.collect.Lists;
import org.sonar.api.utils.DateUtils;
import org.sonar.api.utils.SonarException;

public abstract class Request {
    public abstract String method();

    public abstract String getMediaType();

    public abstract boolean hasParam(String var1);

    public String mandatoryParam(String key) {
        String value = this.param(key);
        if (value == null) {
            throw new IllegalArgumentException(String.format("The '%s' parameter is missing", key));
        }
        return value;
    }

    public boolean mandatoryParamAsBoolean(String key) {
        String s = this.mandatoryParam(key);
        return Request.parseBoolean(key, s);
    }

    public int mandatoryParamAsInt(String key) {
        String s = this.mandatoryParam(key);
        return Integer.parseInt(s);
    }

    public long mandatoryParamAsLong(String key) {
        String s = this.mandatoryParam(key);
        return Long.parseLong(s);
    }

    public <E extends Enum<E>> E mandatoryParamAsEnum(String key, Class<E> enumClass) {
        return Enum.valueOf(enumClass, this.mandatoryParam(key));
    }

    public List<String> mandatoryParamAsStrings(String key) {
        List<String> values = this.paramAsStrings(key);
        if (values == null) {
            throw new IllegalArgumentException(String.format("The '%s' parameter is missing", key));
        }
        return values;
    }

    @CheckForNull
    public List<String> paramAsStrings(String key) {
        String value = this.param(key);
        if (value == null) {
            return null;
        }
        return Lists.newArrayList(Splitter.on(',').omitEmptyStrings().trimResults().split(value));
    }

    @CheckForNull
    public abstract String param(String var1);

    @CheckForNull
    public abstract InputStream paramAsInputStream(String var1);

    @CheckForNull
    @Deprecated
    public String param(String key, @CheckForNull String defaultValue) {
        return StringUtils.defaultString(this.param(key), defaultValue);
    }

    @Deprecated
    public boolean paramAsBoolean(String key, boolean defaultValue) {
        String value = this.param(key);
        return value == null ? defaultValue : Request.parseBoolean(key, value);
    }

    @Deprecated
    public int paramAsInt(String key, int defaultValue) {
        String s = this.param(key);
        return s == null ? defaultValue : Integer.parseInt(s);
    }

    @Deprecated
    public long paramAsLong(String key, long defaultValue) {
        String s = this.param(key);
        return s == null ? defaultValue : Long.parseLong(s);
    }

    @CheckForNull
    public Boolean paramAsBoolean(String key) {
        String value = this.param(key);
        return value == null ? null : Boolean.valueOf(Request.parseBoolean(key, value));
    }

    @CheckForNull
    public Integer paramAsInt(String key) {
        String s = this.param(key);
        return s == null ? null : Integer.valueOf(Integer.parseInt(s));
    }

    @CheckForNull
    public Long paramAsLong(String key) {
        String s = this.param(key);
        return s == null ? null : Long.valueOf(Long.parseLong(s));
    }

    @CheckForNull
    public <E extends Enum<E>> E paramAsEnum(String key, Class<E> enumClass) {
        String s = this.param(key);
        return s == null ? null : (E)Enum.valueOf(enumClass, s);
    }

    @CheckForNull
    public <E extends Enum<E>> List<E> paramAsEnums(String key, Class<E> enumClass) {
        String value = this.param(key);
        if (value == null) {
            return null;
        }
        Iterable<String> values = Splitter.on(',').omitEmptyStrings().trimResults().split(value);
        ArrayList<E> result = new ArrayList<E>();
        for (String s : values) {
            result.add(Enum.valueOf(enumClass, s));
        }
        return result;
    }

    @CheckForNull
    public Date paramAsDateTime(String key) {
        String s = this.param(key);
        if (s != null) {
            try {
                return DateUtils.parseDateTime(s);
            }
            catch (SonarException notDateTime) {
                try {
                    return DateUtils.parseDate(s);
                }
                catch (SonarException notDateEither) {
                    throw new SonarException(String.format("'%s' cannot be parsed as either a date or date+time", s));
                }
            }
        }
        return null;
    }

    @CheckForNull
    public Date paramAsDate(String key) {
        String s = this.param(key);
        if (s != null) {
            return DateUtils.parseDate(s);
        }
        return null;
    }

    private static boolean parseBoolean(String key, String value) {
        if ("true".equals(value) || "yes".equals(value)) {
            return true;
        }
        if ("false".equals(value) || "no".equals(value)) {
            return false;
        }
        throw new IllegalArgumentException(String.format("Property %s is not a boolean value: %s", key, value));
    }
}

