/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.api.server.debt.internal;

import javax.annotation.CheckForNull;
import javax.annotation.Nullable;
import org.sonar.api.internal.apachecommons.lang.StringUtils;
import org.sonar.api.internal.apachecommons.lang.builder.EqualsBuilder;
import org.sonar.api.internal.google.common.base.Objects;
import org.sonar.api.internal.google.common.base.Preconditions;
import org.sonar.api.server.debt.DebtRemediationFunction;
import org.sonar.api.utils.Duration;

public class DefaultDebtRemediationFunction
implements DebtRemediationFunction {
    private static final int HOURS_IN_DAY = 24;
    private final DebtRemediationFunction.Type type;
    private final String coefficient;
    private final String offset;

    public DefaultDebtRemediationFunction(@Nullable DebtRemediationFunction.Type type, @Nullable String coefficient, @Nullable String offset) {
        this.type = type;
        this.coefficient = DefaultDebtRemediationFunction.sanitizeValue("coefficient", coefficient);
        this.offset = DefaultDebtRemediationFunction.sanitizeValue("offset", offset);
        this.validate();
    }

    @CheckForNull
    private static String sanitizeValue(String label, @Nullable String s) {
        if (StringUtils.isNotBlank(s)) {
            try {
                Duration duration = Duration.decode(s, 24);
                return duration.encode(24);
            }
            catch (Exception e) {
                throw new IllegalArgumentException(String.format("Invalid %s: %s (%s)", label, s, e.getMessage()), e);
            }
        }
        return null;
    }

    @Override
    public DebtRemediationFunction.Type type() {
        return this.type;
    }

    @Override
    @CheckForNull
    public String coefficient() {
        return this.coefficient;
    }

    @Override
    @CheckForNull
    public String offset() {
        return this.offset;
    }

    private void validate() {
        Preconditions.checkArgument(this.type != null, "Remediation function type cannot be null");
        switch (this.type) {
            case LINEAR: {
                Preconditions.checkArgument(this.coefficient != null && this.offset == null, "Linear functions must only have a non empty coefficient");
                break;
            }
            case LINEAR_OFFSET: {
                Preconditions.checkArgument(this.coefficient != null && this.offset != null, "Linear with offset functions must have both non null coefficient and offset");
                break;
            }
            case CONSTANT_ISSUE: {
                Preconditions.checkArgument(this.coefficient == null && this.offset != null, "Constant/issue functions must only have a non empty offset");
                break;
            }
            default: {
                throw new IllegalArgumentException(String.format("Unknown type on %s", this));
            }
        }
    }

    public boolean equals(Object o) {
        if (!(o instanceof DefaultDebtRemediationFunction)) {
            return false;
        }
        if (this == o) {
            return true;
        }
        DefaultDebtRemediationFunction other = (DefaultDebtRemediationFunction)o;
        return new EqualsBuilder().append(this.coefficient, other.coefficient()).append(this.offset, other.offset()).append((Object)this.type, (Object)other.type()).isEquals();
    }

    public int hashCode() {
        int result = this.type.hashCode();
        result = 31 * result + (this.coefficient != null ? this.coefficient.hashCode() : 0);
        result = 31 * result + (this.offset != null ? this.offset.hashCode() : 0);
        return result;
    }

    public String toString() {
        return Objects.toStringHelper(DebtRemediationFunction.class).add("type", (Object)this.type).add("coefficient", this.coefficient).add("offset", this.offset).toString();
    }
}

