/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.api.measures;

import java.util.ArrayList;
import java.util.Collection;
import org.sonar.api.measures.Measure;
import org.sonar.api.measures.MeasuresFilter;
import org.sonar.api.measures.Metric;
import org.sonar.api.measures.RuleMeasure;
import org.sonar.api.rule.RuleKey;
import org.sonar.api.rules.Rule;
import org.sonar.api.technicaldebt.batch.Characteristic;
import org.sonar.api.technicaldebt.batch.Requirement;

public final class MeasuresFilters {
    private MeasuresFilters() {
    }

    public static MeasuresFilter<Collection<Measure>> all() {
        return new MeasuresFilter<Collection<Measure>>(){

            @Override
            public Collection<Measure> filter(Collection<Measure> measures) {
                ArrayList<Measure> all = new ArrayList<Measure>();
                for (Measure measure : measures) {
                    if (measure == null) continue;
                    all.add(measure);
                }
                return all;
            }
        };
    }

    public static MeasuresFilter<Measure> metric(org.sonar.api.batch.measure.Metric<?> metric) {
        return MeasuresFilters.metric(metric.key());
    }

    public static MeasuresFilter<Measure> metric(final String metricKey) {
        return new MetricFilter<Measure>(metricKey){

            @Override
            public Measure filter(Collection<Measure> measures) {
                if (measures == null) {
                    return null;
                }
                for (Measure measure : measures) {
                    if (!measure.getClass().equals(Measure.class) || !measure.getMetricKey().equals(metricKey) || measure.getCharacteristic() != null || measure.getPersonId() != null) continue;
                    return measure;
                }
                return null;
            }
        };
    }

    public static MeasuresFilter<Measure> characteristic(final Metric metric, final Characteristic characteristic) {
        return new MetricFilter<Measure>(metric){

            @Override
            public Measure filter(Collection<Measure> measures) {
                if (measures == null) {
                    return null;
                }
                for (Measure measure : measures) {
                    if (!measure.getClass().equals(Measure.class) || !measure.getMetric().equals(metric) || measure.getPersonId() != null || !MeasuresFilters.isSameCharacteristic(measure, characteristic)) continue;
                    return measure;
                }
                return null;
            }
        };
    }

    private static boolean isSameCharacteristic(Measure measure, Characteristic characteristic) {
        Characteristic measureCharacteristic = measure.getCharacteristic();
        return measureCharacteristic != null && measureCharacteristic.equals(characteristic);
    }

    @Deprecated
    public static MeasuresFilter<Measure> requirement(final Metric metric, final Requirement requirement) {
        return new MetricFilter<Measure>(metric){

            @Override
            public Measure filter(Collection<Measure> measures) {
                if (measures == null) {
                    return null;
                }
                for (Measure measure : measures) {
                    if (!measure.getClass().equals(Measure.class) || !measure.getMetric().equals(metric) || measure.getPersonId() != null || !MeasuresFilters.isSameRequirement(measure, requirement)) continue;
                    return measure;
                }
                return null;
            }
        };
    }

    private static boolean isSameRequirement(Measure measure, Requirement requirement) {
        Requirement measureRequirement = measure.getRequirement();
        return measureRequirement != null && measureRequirement.equals(requirement);
    }

    public static MeasuresFilter<Measure> measure(final Measure measure) {
        return new MeasuresFilter<Measure>(){

            @Override
            public Measure filter(Collection<Measure> measures) {
                if (measures == null) {
                    return null;
                }
                for (Measure m : measures) {
                    if (!m.equals(measure)) continue;
                    return m;
                }
                return null;
            }
        };
    }

    public static MeasuresFilter<RuleMeasure> rule(Metric metric, RuleKey ruleKey) {
        return new RuleFilter(metric, ruleKey);
    }

    public static MeasuresFilter<RuleMeasure> rule(Metric metric, Rule rule) {
        return MeasuresFilters.rule(metric, rule.ruleKey());
    }

    public static MeasuresFilter<Collection<RuleMeasure>> rules(final Metric metric) {
        return new MetricFilter<Collection<RuleMeasure>>(metric){

            private boolean apply(Measure measure) {
                return measure instanceof RuleMeasure && metric.equals(measure.getMetric()) && measure.getPersonId() == null && ((RuleMeasure)measure).ruleKey() != null;
            }

            @Override
            public Collection<RuleMeasure> filter(Collection<Measure> measures) {
                if (measures == null) {
                    return null;
                }
                ArrayList<RuleMeasure> result = new ArrayList<RuleMeasure>();
                for (Measure measure : measures) {
                    if (!this.apply(measure)) continue;
                    result.add((RuleMeasure)measure);
                }
                return result;
            }
        };
    }

    @Deprecated
    private static class RuleFilter
    extends AbstractRuleMeasureFilter<RuleMeasure> {
        private RuleKey ruleKey;

        protected RuleFilter(Metric metric, RuleKey ruleKey) {
            super(metric);
            this.ruleKey = ruleKey;
        }

        @Override
        boolean doApply(RuleMeasure measure) {
            return measure.ruleKey() != null && this.ruleKey.equals(measure.ruleKey());
        }
    }

    @Deprecated
    private static abstract class AbstractRuleMeasureFilter<M>
    extends MetricFilter<M> {
        protected AbstractRuleMeasureFilter(Metric metric) {
            super(metric);
        }

        private boolean apply(Measure measure) {
            return measure instanceof RuleMeasure && this.filterOnMetricKey().equals(measure.getMetricKey()) && measure.getPersonId() == null && this.doApply((RuleMeasure)measure);
        }

        abstract boolean doApply(RuleMeasure var1);

        @Override
        public M filter(Collection<Measure> measures) {
            if (measures == null) {
                return null;
            }
            for (Measure measure : measures) {
                if (!this.apply(measure)) continue;
                return (M)measure;
            }
            return null;
        }
    }

    public static abstract class MetricFilter<M>
    implements MeasuresFilter<M> {
        private final String metricKey;

        protected MetricFilter(Metric metric) {
            this.metricKey = metric.getKey();
        }

        protected MetricFilter(String metricKey) {
            this.metricKey = metricKey;
        }

        public String filterOnMetricKey() {
            return this.metricKey;
        }
    }
}

