/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.api.batch.sensor.internal;

import java.io.File;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.CheckForNull;
import org.sonar.api.batch.AnalysisMode;
import org.sonar.api.batch.fs.internal.DefaultFileSystem;
import org.sonar.api.batch.fs.internal.DefaultTextPointer;
import org.sonar.api.batch.rule.ActiveRules;
import org.sonar.api.batch.rule.internal.ActiveRulesBuilder;
import org.sonar.api.batch.sensor.SensorContext;
import org.sonar.api.batch.sensor.coverage.CoverageType;
import org.sonar.api.batch.sensor.coverage.NewCoverage;
import org.sonar.api.batch.sensor.coverage.internal.DefaultCoverage;
import org.sonar.api.batch.sensor.highlighting.NewHighlighting;
import org.sonar.api.batch.sensor.highlighting.TypeOfText;
import org.sonar.api.batch.sensor.highlighting.internal.DefaultHighlighting;
import org.sonar.api.batch.sensor.highlighting.internal.SyntaxHighlightingRule;
import org.sonar.api.batch.sensor.internal.SensorStorage;
import org.sonar.api.batch.sensor.issue.Issue;
import org.sonar.api.batch.sensor.issue.NewIssue;
import org.sonar.api.batch.sensor.issue.internal.DefaultIssue;
import org.sonar.api.batch.sensor.measure.Measure;
import org.sonar.api.batch.sensor.measure.NewMeasure;
import org.sonar.api.batch.sensor.measure.internal.DefaultMeasure;
import org.sonar.api.config.Settings;
import org.sonar.api.internal.google.common.annotations.Beta;
import org.sonar.api.internal.google.common.collect.HashBasedTable;
import org.sonar.api.internal.google.common.collect.Table;
import org.sonar.api.measures.Metric;

@Beta
public class SensorContextTester
implements SensorContext {
    private Settings settings = new Settings();
    private DefaultFileSystem fs;
    private ActiveRules activeRules;
    private MockAnalysisMode analysisMode;
    private InMemorySensorStorage sensorStorage;

    private SensorContextTester(File moduleBaseDir) {
        this.fs = new DefaultFileSystem(moduleBaseDir);
        this.activeRules = new ActiveRulesBuilder().build();
        this.analysisMode = new MockAnalysisMode();
        this.sensorStorage = new InMemorySensorStorage();
    }

    public static SensorContextTester create(File moduleBaseDir) {
        return new SensorContextTester(moduleBaseDir);
    }

    @Override
    public Settings settings() {
        return this.settings;
    }

    public void setSettings(Settings settings) {
        this.settings = settings;
    }

    @Override
    public DefaultFileSystem fileSystem() {
        return this.fs;
    }

    public void setFileSystem(DefaultFileSystem fs) {
        this.fs = fs;
    }

    @Override
    public ActiveRules activeRules() {
        return this.activeRules;
    }

    public void setActiveRules(ActiveRules activeRules) {
        this.activeRules = activeRules;
    }

    @Override
    public MockAnalysisMode analysisMode() {
        return this.analysisMode;
    }

    @Override
    public <G extends Serializable> NewMeasure<G> newMeasure() {
        return new DefaultMeasure(this.sensorStorage);
    }

    public Collection<Measure> measures(String componentKey) {
        return this.sensorStorage.measuresByComponentAndMetric.row(componentKey).values();
    }

    public <G extends Serializable> Measure<G> measure(String componetKey, Metric<G> metric) {
        return this.measure(componetKey, metric.key());
    }

    public <G extends Serializable> Measure<G> measure(String componentKey, String metricKey) {
        return (Measure)this.sensorStorage.measuresByComponentAndMetric.row(componentKey).get(metricKey);
    }

    @Override
    public NewIssue newIssue() {
        return new DefaultIssue(this.sensorStorage);
    }

    public Collection<Issue> allIssues() {
        return this.sensorStorage.allIssues;
    }

    @CheckForNull
    public Integer lineHits(String fileKey, CoverageType type, int line) {
        Map defaultCoverageByType = (Map)this.sensorStorage.coverageByComponent.get(fileKey);
        if (defaultCoverageByType == null) {
            return null;
        }
        if (defaultCoverageByType.containsKey((Object)type)) {
            return (Integer)((DefaultCoverage)defaultCoverageByType.get((Object)type)).hitsByLine().get(line);
        }
        return null;
    }

    @CheckForNull
    public Integer conditions(String fileKey, CoverageType type, int line) {
        Map defaultCoverageByType = (Map)this.sensorStorage.coverageByComponent.get(fileKey);
        if (defaultCoverageByType == null) {
            return null;
        }
        if (defaultCoverageByType.containsKey((Object)type)) {
            return (Integer)((DefaultCoverage)defaultCoverageByType.get((Object)type)).conditionsByLine().get(line);
        }
        return null;
    }

    @CheckForNull
    public Integer coveredConditions(String fileKey, CoverageType type, int line) {
        Map defaultCoverageByType = (Map)this.sensorStorage.coverageByComponent.get(fileKey);
        if (defaultCoverageByType == null) {
            return null;
        }
        if (defaultCoverageByType.containsKey((Object)type)) {
            return (Integer)((DefaultCoverage)defaultCoverageByType.get((Object)type)).coveredConditionsByLine().get(line);
        }
        return null;
    }

    @Override
    public NewHighlighting newHighlighting() {
        return new DefaultHighlighting(this.sensorStorage);
    }

    @Override
    public NewCoverage newCoverage() {
        return new DefaultCoverage(this.sensorStorage);
    }

    public List<TypeOfText> highlightingTypeAt(String componentKey, int line, int lineOffset) {
        DefaultHighlighting syntaxHighlightingData = (DefaultHighlighting)this.sensorStorage.highlightingByComponent.get(componentKey);
        if (syntaxHighlightingData == null) {
            return Collections.emptyList();
        }
        ArrayList<TypeOfText> result = new ArrayList<TypeOfText>();
        DefaultTextPointer location = new DefaultTextPointer(line, lineOffset);
        for (SyntaxHighlightingRule sortedRule : syntaxHighlightingData.getSyntaxHighlightingRuleSet()) {
            if (sortedRule.range().start().compareTo(location) > 0 || sortedRule.range().end().compareTo(location) <= 0) continue;
            result.add(sortedRule.getTextType());
        }
        return result;
    }

    private static class InMemorySensorStorage
    implements SensorStorage {
        private Table<String, String, Measure> measuresByComponentAndMetric = HashBasedTable.create();
        private Collection<Issue> allIssues = new ArrayList<Issue>();
        private Map<String, DefaultHighlighting> highlightingByComponent = new HashMap<String, DefaultHighlighting>();
        private Map<String, Map<CoverageType, DefaultCoverage>> coverageByComponent = new HashMap<String, Map<CoverageType, DefaultCoverage>>();

        private InMemorySensorStorage() {
        }

        @Override
        public void store(Measure measure) {
            this.measuresByComponentAndMetric.row(measure.inputComponent().key()).put(measure.metric().key(), measure);
        }

        @Override
        public void store(Issue issue) {
            this.allIssues.add(issue);
        }

        @Override
        public void store(DefaultHighlighting highlighting) {
            this.highlightingByComponent.put(highlighting.inputFile().key(), highlighting);
        }

        @Override
        public void store(DefaultCoverage defaultCoverage) {
            String key = defaultCoverage.inputFile().key();
            if (!this.coverageByComponent.containsKey(key)) {
                this.coverageByComponent.put(key, new EnumMap(CoverageType.class));
            }
            this.coverageByComponent.get(key).put(defaultCoverage.type(), defaultCoverage);
        }
    }

    public static class MockAnalysisMode
    implements AnalysisMode {
        private boolean isPreview = false;
        private boolean isIssues = false;

        @Override
        public boolean isPreview() {
            return this.isPreview;
        }

        public void setPreview(boolean value) {
            this.isPreview = value;
        }

        @Override
        public boolean isIssues() {
            return this.isIssues;
        }

        public void setIssues(boolean issues) {
            this.isIssues = issues;
        }

        @Override
        public boolean isPublish() {
            return !this.isPreview && !this.isIssues;
        }
    }
}

